/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import org.eclipse.paho.mqttv5.client.internal.ExceptionHelper;

public class FileLock {
    private File lockFile;
    private RandomAccessFile file;
    private Object fileLock;

    public FileLock(File clientDir, String lockFilename) throws Exception {
        this.lockFile = new File(clientDir, lockFilename);
        if (ExceptionHelper.isClassAvailable("java.nio.channels.FileLock")) {
            try {
                this.file = new RandomAccessFile(this.lockFile, "rw");
                Method m4 = this.file.getClass().getMethod("getChannel", new Class[0]);
                Object channel2 = m4.invoke((Object)this.file, new Object[0]);
                m4 = channel2.getClass().getMethod("tryLock", new Class[0]);
                this.fileLock = m4.invoke(channel2, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fileLock = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fileLock = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.fileLock = null;
            }
            if (this.fileLock == null) {
                this.release();
                throw new Exception("Problem obtaining file lock");
            }
        }
    }

    public void release() {
        try {
            if (this.fileLock != null) {
                Method m4 = this.fileLock.getClass().getMethod("release", new Class[0]);
                m4.invoke(this.fileLock, new Object[0]);
                this.fileLock = null;
            }
        }
        catch (Exception exception) {}
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {}
            this.file = null;
        }
        if (this.lockFile != null && this.lockFile.exists()) {
            this.lockFile.delete();
        }
        this.lockFile = null;
    }
}

