/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.common.MqttException;

public class NetworkModuleService {
    private static Logger LOG = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", NetworkModuleService.class.getSimpleName());
    private static final ServiceLoader<NetworkModuleFactory> FACTORY_SERVICE_LOADER = ServiceLoader.load(NetworkModuleFactory.class, NetworkModuleService.class.getClassLoader());
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("((.+)@)?([^:]*)(:(\\d+))?");
    private static final int AUTH_GROUP_USERINFO = 2;
    private static final int AUTH_GROUP_HOST = 3;
    private static final int AUTH_GROUP_PORT = 5;

    private NetworkModuleService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateURI(String brokerUri) throws IllegalArgumentException {
        try {
            URI uri = new URI(brokerUri);
            String scheme = uri.getScheme();
            if (scheme == null || scheme.isEmpty()) {
                throw new IllegalArgumentException("missing scheme in broker URI: " + brokerUri);
            }
            scheme = scheme.toLowerCase();
            ServiceLoader<NetworkModuleFactory> serviceLoader = FACTORY_SERVICE_LOADER;
            synchronized (serviceLoader) {
                for (NetworkModuleFactory factory2 : FACTORY_SERVICE_LOADER) {
                    if (!factory2.getSupportedUriSchemes().contains(scheme)) continue;
                    factory2.validateURI(uri);
                    return;
                }
            }
            throw new IllegalArgumentException("no NetworkModule installed for scheme \"" + scheme + "\" of URI \"" + brokerUri + "\"");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't parse string to URI \"" + brokerUri + "\"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkModule createInstance(String address, MqttConnectionOptions options2, String clientId) throws MqttException, IllegalArgumentException {
        try {
            URI brokerUri = new URI(address);
            NetworkModuleService.applyRFC3986AuthorityPatch(brokerUri);
            String scheme = brokerUri.getScheme().toLowerCase();
            ServiceLoader<NetworkModuleFactory> serviceLoader = FACTORY_SERVICE_LOADER;
            synchronized (serviceLoader) {
                for (NetworkModuleFactory factory2 : FACTORY_SERVICE_LOADER) {
                    if (!factory2.getSupportedUriSchemes().contains(scheme)) continue;
                    return factory2.createNetworkModule(brokerUri, options2, clientId);
                }
            }
            throw new IllegalArgumentException(brokerUri.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(address, e);
        }
    }

    static void applyRFC3986AuthorityPatch(URI toPatch) {
        if (toPatch == null || toPatch.getHost() != null || toPatch.getAuthority() == null || toPatch.getAuthority().isEmpty()) {
            return;
        }
        Matcher matcher = AUTHORITY_PATTERN.matcher(toPatch.getAuthority());
        if (matcher.find()) {
            NetworkModuleService.setURIField(toPatch, "userInfo", matcher.group(2));
            NetworkModuleService.setURIField(toPatch, "host", matcher.group(3));
            String portString = matcher.group(5);
            NetworkModuleService.setURIField(toPatch, "port", portString != null ? Integer.parseInt(portString) : -1);
        }
    }

    private static void setURIField(URI toManipulate, String fieldName, Object newValue) {
        try {
            Field field = URI.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(toManipulate, newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.warning(NetworkModuleService.class.getName(), "setURIField", "115", new Object[]{toManipulate.toString()}, e);
        }
    }
}

