/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.common.MqttPersistable;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;

public class MemoryPersistence
implements MqttClientPersistence {
    private Hashtable<String, MqttPersistable> data;

    @Override
    public void close() throws MqttPersistenceException {
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public Enumeration<String> keys() throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.keys();
    }

    @Override
    public MqttPersistable get(String key2) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.get(key2);
    }

    @Override
    public void open(String clientId) throws MqttPersistenceException {
        this.data = new Hashtable();
    }

    @Override
    public void put(String key2, MqttPersistable persistable) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.put(key2, persistable);
    }

    @Override
    public void remove(String key2) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.remove(key2);
    }

    @Override
    public void clear() throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.clear();
    }

    @Override
    public boolean containsKey(String key2) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.containsKey(key2);
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.data == null) {
            throw new MqttPersistenceException();
        }
    }
}

