/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class MqttAuth
extends MqttWireMessage {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[3];
        nArray[1] = 24;
        nArray[2] = 25;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)21, (byte)22, (byte)31, (byte)38};
    }

    public MqttAuth(byte[] data2) throws IOException, MqttException {
        super((byte)15);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data2);
        DataInputStream inputStream2 = new DataInputStream(bais);
        this.reasonCode = inputStream2.readUnsignedByte();
        this.validateReturnCode(this.reasonCode, validReturnCodes);
        this.properties.decodeProperties(inputStream2);
        inputStream2.close();
    }

    public MqttAuth(int returnCode, MqttProperties properties2) throws MqttException {
        super((byte)15);
        this.properties = properties2 != null ? properties2 : new MqttProperties();
        this.properties.setValidProperties(validProperties);
        this.validateReturnCode(returnCode, validReturnCodes);
        this.reasonCode = returnCode;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream2 = new DataOutputStream(baos);
            outputStream2.writeByte(this.reasonCode);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream2.write(identifierValueFieldsByteArray);
            outputStream2.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    protected byte getMessageInfo() {
        return 1;
    }

    public int getReturnCode() {
        return this.reasonCode;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttAuth [returnCode=" + this.reasonCode + ", properties=" + this.properties + "]";
    }
}

