/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.util.VariableByteInteger;

public class MqttDataTypes {
    private static final int TWO_BYTE_INT_MAX = 65535;
    private static final long FOUR_BYTE_INT_MAX = 0xFFFFFFFFL;
    public static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    protected static final Charset STRING_ENCODING = StandardCharsets.UTF_8;

    public MqttDataTypes() throws IllegalAccessException {
        throw new IllegalAccessException("Utility Class");
    }

    public static void validateTwoByteInt(Integer value2) throws IllegalArgumentException {
        if (value2 == null) {
            return;
        }
        if (value2 >= 0 && value2 <= 65535) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 65535");
    }

    public static void validateFourByteInt(Long value2) throws IllegalArgumentException {
        if (value2 == null) {
            return;
        }
        if (value2 >= 0L && value2 <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 4294967295");
    }

    public static void validateVariableByteInt(int value2) throws IllegalArgumentException {
        if (value2 >= 0 && value2 <= 0xFFFFFFF) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 268435455");
    }

    public static void writeUnsignedFourByteInt(long value2, DataOutputStream stream) throws IOException {
        stream.writeByte((byte)(value2 >>> 24));
        stream.writeByte((byte)(value2 >>> 16));
        stream.writeByte((byte)(value2 >>> 8));
        stream.writeByte((byte)(value2 >>> 0));
    }

    public static Long readUnsignedFourByteInt(DataInputStream inputStream2) throws IOException {
        byte[] readBuffer = new byte[8];
        inputStream2.readFully(readBuffer, 4, 4);
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)((readBuffer[7] & 0xFF) << 0);
    }

    public static int readUnsignedTwoByteInt(DataInputStream inputStream2) throws IOException {
        int ch2;
        int ch1 = inputStream2.read();
        if ((ch1 | (ch2 = inputStream2.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public static void encodeUTF8(DataOutputStream dos, String stringToEncode) throws MqttException {
        MqttDataTypes.validateUTF8String(stringToEncode);
        try {
            byte[] encodedString = stringToEncode.getBytes(STRING_ENCODING);
            byte byte1 = (byte)(encodedString.length >>> 8 & 0xFF);
            byte byte2 = (byte)(encodedString.length >>> 0 & 0xFF);
            dos.write(byte1);
            dos.write(byte2);
            dos.write(encodedString);
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public static String decodeUTF8(DataInputStream input) throws MqttException {
        try {
            int encodedLength = input.readUnsignedShort();
            byte[] encodedString = new byte[encodedLength];
            input.readFully(encodedString);
            String output = new String(encodedString, STRING_ENCODING);
            MqttDataTypes.validateUTF8String(output);
            return output;
        }
        catch (IOException ioe) {
            throw new MqttException(50002, (Throwable)ioe);
        }
    }

    private static void validateUTF8String(String input) throws IllegalArgumentException {
        int i = 0;
        while (i < input.length()) {
            boolean isBad = false;
            char c = input.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (++i == input.length()) {
                    isBad = true;
                } else {
                    char c2 = input.charAt(i);
                    if (!Character.isLowSurrogate(c2)) {
                        isBad = true;
                    } else {
                        int ch = (c & 0x3FF) << 10 | c2 & 0x3FF;
                        if ((ch & 0xFFFF) == 65535 || (ch & 0xFFFF) == 65534) {
                            isBad = true;
                        }
                    }
                }
            } else if (Character.isISOControl(c) || Character.isLowSurrogate(c)) {
                isBad = true;
            } else if (c >= '\ufdd0' && (c <= '\ufddf' || c >= '\ufffe')) {
                isBad = true;
            }
            if (isBad) {
                throw new IllegalArgumentException(String.format("Invalid UTF-8 char: [%04x]", c));
            }
            ++i;
        }
    }

    public static VariableByteInteger readVariableByteInteger(DataInputStream in) throws IOException {
        byte digit;
        int value2 = 0;
        int multiplier = 1;
        int count2 = 0;
        do {
            digit = in.readByte();
            ++count2;
            value2 += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        if (value2 < 0 || value2 > 0xFFFFFFF) {
            throw new IOException("This property must be a number between 0 and 268435455. Read value was: " + value2);
        }
        return new VariableByteInteger(value2, count2);
    }

    public static byte[] encodeVariableByteInteger(int number) throws IllegalArgumentException {
        MqttDataTypes.validateVariableByteInt(number);
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            baos.write(digit);
        } while (no > 0L && ++numBytes < 4);
        return baos.toByteArray();
    }
}

