/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttPersistable;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public abstract class MqttPersistableWireMessage
extends MqttWireMessage
implements MqttPersistable {
    public MqttPersistableWireMessage(byte type2) {
        super(type2);
    }

    @Override
    public byte[] getHeaderBytes() throws MqttPersistenceException {
        byte[] headerBytes = null;
        try {
            if (this.getClass() == MqttPublish.class && this.getProperties().getTopicAlias() != null) {
                MqttProperties props = this.getProperties();
                Integer topicAlias = props.getTopicAlias();
                props.setTopicAlias(null);
                headerBytes = this.getHeader();
                props.setTopicAlias(topicAlias);
                this.properties = props;
            } else {
                headerBytes = this.getHeader();
            }
            return headerBytes;
        }
        catch (MqttException ex) {
            throw new MqttPersistenceException(ex.getCause());
        }
    }

    @Override
    public int getHeaderLength() throws MqttPersistenceException {
        return this.getHeaderBytes().length;
    }

    @Override
    public int getHeaderOffset() throws MqttPersistenceException {
        return 0;
    }

    @Override
    public byte[] getPayloadBytes() throws MqttPersistenceException {
        try {
            return this.getPayload();
        }
        catch (MqttException ex) {
            throw new MqttPersistenceException(ex.getCause());
        }
    }

    @Override
    public int getPayloadLength() throws MqttPersistenceException {
        return 0;
    }

    @Override
    public int getPayloadOffset() throws MqttPersistenceException {
        return 0;
    }
}

