/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttDataTypes;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.eclipse.paho.mqttv5.common.util.MqttTopicValidator;

public class MqttProperties {
    public static final byte PAYLOAD_FORMAT_INDICATOR_IDENTIFIER = 1;
    public static final byte MESSAGE_EXPIRY_INTERVAL_IDENTIFIER = 2;
    public static final byte CONTENT_TYPE_IDENTIFIER = 3;
    public static final byte RESPONSE_TOPIC_IDENTIFIER = 8;
    public static final byte CORRELATION_DATA_IDENTIFIER = 9;
    public static final byte SUBSCRIPTION_IDENTIFIER = 11;
    public static final byte SUBSCRIPTION_IDENTIFIER_MULTI = 126;
    public static final byte SUBSCRIPTION_IDENTIFIER_SINGLE = 127;
    public static final byte SESSION_EXPIRY_INTERVAL_IDENTIFIER = 17;
    public static final byte ASSIGNED_CLIENT_IDENTIFIER_IDENTIFIER = 18;
    public static final byte SERVER_KEEP_ALIVE_IDENTIFIER = 19;
    public static final byte AUTH_METHOD_IDENTIFIER = 21;
    public static final byte AUTH_DATA_IDENTIFIER = 22;
    public static final byte REQUEST_PROBLEM_INFO_IDENTIFIER = 23;
    public static final byte WILL_DELAY_INTERVAL_IDENTIFIER = 24;
    public static final byte REQUEST_RESPONSE_INFO_IDENTIFIER = 25;
    public static final byte RESPONSE_INFO_IDENTIFIER = 26;
    public static final byte SERVER_REFERENCE_IDENTIFIER = 28;
    public static final byte REASON_STRING_IDENTIFIER = 31;
    public static final byte RECEIVE_MAXIMUM_IDENTIFIER = 33;
    public static final byte TOPIC_ALIAS_MAXIMUM_IDENTIFIER = 34;
    public static final byte TOPIC_ALIAS_IDENTIFIER = 35;
    public static final byte MAXIMUM_QOS_IDENTIFIER = 36;
    public static final byte RETAIN_AVAILABLE_IDENTIFIER = 37;
    public static final byte USER_DEFINED_PAIR_IDENTIFIER = 38;
    public static final byte MAXIMUM_PACKET_SIZE_IDENTIFIER = 39;
    public static final byte WILDCARD_SUB_AVAILABLE_IDENTIFIER = 40;
    public static final byte SUBSCRIPTION_AVAILABLE_IDENTIFIER = 41;
    public static final byte SHARED_SUBSCRIPTION_AVAILABLE_IDENTIFIER = 42;
    private List<Byte> validProperties;
    private Boolean payloadFormat = false;
    private Boolean requestProblemInfo;
    private Boolean requestResponseInfo;
    private Integer maximumQoS;
    private Boolean retainAvailable = null;
    private Boolean wildcardSubscriptionsAvailable = null;
    private Boolean subscriptionIdentifiersAvailable = null;
    private Boolean sharedSubscriptionAvailable = null;
    private Integer serverKeepAlive;
    private Integer receiveMaximum;
    private Integer topicAliasMaximum;
    private Integer topicAlias;
    private Long messageExpiryInterval;
    private Long sessionExpiryInterval;
    private Long willDelayInterval;
    private Long maximumPacketSize;
    private String contentType;
    private String responseTopic;
    private String assignedClientIdentifier;
    private String authenticationMethod;
    private String responseInfo;
    private String serverReference;
    private String reasonString;
    private List<UserProperty> userProperties = new ArrayList<UserProperty>();
    private byte[] correlationData;
    private byte[] authenticationData;
    private List<Integer> publishSubscriptionIdentifiers = new ArrayList<Integer>();
    private Integer subscribeSubscriptionIdentifier;

    public MqttProperties() {
    }

    public MqttProperties(Byte[] validProperties) {
        this.validProperties = Arrays.asList(validProperties);
    }

    public void setValidProperties(Byte[] validProperties) {
        this.validProperties = Arrays.asList(validProperties);
    }

    public byte[] encodeProperties() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream2 = new DataOutputStream(baos);
            if (this.payloadFormat.booleanValue() && this.validProperties.contains((byte)1)) {
                outputStream2.write(1);
                outputStream2.writeByte(1);
            }
            if (this.messageExpiryInterval != null && this.validProperties.contains((byte)2)) {
                outputStream2.write(2);
                MqttDataTypes.writeUnsignedFourByteInt(this.messageExpiryInterval, outputStream2);
            }
            if (this.contentType != null && this.validProperties.contains((byte)3)) {
                outputStream2.write(3);
                MqttDataTypes.encodeUTF8(outputStream2, this.contentType);
            }
            if (this.responseTopic != null && this.validProperties.contains((byte)8)) {
                outputStream2.write(8);
                MqttDataTypes.encodeUTF8(outputStream2, this.responseTopic);
            }
            if (this.correlationData != null && this.validProperties.contains((byte)9)) {
                outputStream2.write(9);
                outputStream2.writeShort(this.correlationData.length);
                outputStream2.write(this.correlationData);
            }
            if (!this.publishSubscriptionIdentifiers.isEmpty() && this.validProperties.contains((byte)126)) {
                for (Integer subscriptionIdentifier : this.publishSubscriptionIdentifiers) {
                    outputStream2.write(11);
                    outputStream2.write(MqttDataTypes.encodeVariableByteInteger(subscriptionIdentifier));
                }
            }
            if (this.subscribeSubscriptionIdentifier != null && this.validProperties.contains((byte)127)) {
                outputStream2.write(11);
                outputStream2.write(MqttDataTypes.encodeVariableByteInteger(this.subscribeSubscriptionIdentifier));
            }
            if (this.sessionExpiryInterval != null && this.validProperties.contains((byte)17)) {
                outputStream2.write(17);
                MqttDataTypes.writeUnsignedFourByteInt(this.sessionExpiryInterval, outputStream2);
            }
            if (this.assignedClientIdentifier != null && this.validProperties.contains((byte)18)) {
                outputStream2.write(18);
                MqttDataTypes.encodeUTF8(outputStream2, this.assignedClientIdentifier);
            }
            if (this.serverKeepAlive != null && this.validProperties.contains((byte)19)) {
                outputStream2.write(19);
                outputStream2.writeShort(this.serverKeepAlive);
            }
            if (this.authenticationMethod != null && this.validProperties.contains((byte)21)) {
                outputStream2.write(21);
                MqttDataTypes.encodeUTF8(outputStream2, this.authenticationMethod);
            }
            if (this.authenticationData != null && this.validProperties.contains((byte)22)) {
                outputStream2.write(22);
                outputStream2.writeShort(this.authenticationData.length);
                outputStream2.write(this.authenticationData);
            }
            if (this.requestProblemInfo != null && this.validProperties.contains((byte)23)) {
                outputStream2.write(23);
                outputStream2.write(this.requestProblemInfo != false ? 1 : 0);
            }
            if (this.willDelayInterval != null && this.validProperties.contains((byte)24)) {
                outputStream2.write(24);
                MqttDataTypes.writeUnsignedFourByteInt(this.willDelayInterval, outputStream2);
            }
            if (this.requestResponseInfo != null && this.validProperties.contains((byte)25)) {
                outputStream2.write(25);
                outputStream2.write(this.requestResponseInfo != false ? 1 : 0);
            }
            if (this.responseInfo != null && this.validProperties.contains((byte)26)) {
                outputStream2.write(26);
                MqttDataTypes.encodeUTF8(outputStream2, this.responseInfo);
            }
            if (this.serverReference != null && this.validProperties.contains((byte)28)) {
                outputStream2.write(28);
                MqttDataTypes.encodeUTF8(outputStream2, this.serverReference);
            }
            if (this.reasonString != null && this.validProperties.contains((byte)31)) {
                outputStream2.write(31);
                MqttDataTypes.encodeUTF8(outputStream2, this.reasonString);
            }
            if (this.receiveMaximum != null && this.validProperties.contains((byte)33)) {
                outputStream2.write(33);
                outputStream2.writeShort(this.receiveMaximum);
            }
            if (this.topicAliasMaximum != null && this.validProperties.contains((byte)34)) {
                outputStream2.write(34);
                outputStream2.writeShort(this.topicAliasMaximum);
            }
            if (this.topicAlias != null && this.validProperties.contains((byte)35)) {
                outputStream2.write(35);
                outputStream2.writeShort(this.topicAlias);
            }
            if (this.maximumQoS != null && this.validProperties.contains((byte)36)) {
                outputStream2.write(36);
                outputStream2.writeByte(this.maximumQoS);
            }
            if (this.retainAvailable != null && this.validProperties.contains((byte)37)) {
                outputStream2.write(37);
                outputStream2.writeBoolean(this.retainAvailable);
            }
            if (this.userProperties != null && !this.userProperties.isEmpty() && this.validProperties.contains((byte)38)) {
                for (UserProperty property : this.userProperties) {
                    outputStream2.writeByte(38);
                    MqttDataTypes.encodeUTF8(outputStream2, property.getKey());
                    MqttDataTypes.encodeUTF8(outputStream2, property.getValue());
                }
            }
            if (this.maximumPacketSize != null && this.validProperties.contains((byte)39)) {
                outputStream2.write(39);
                MqttDataTypes.writeUnsignedFourByteInt(this.maximumPacketSize, outputStream2);
            }
            if (this.wildcardSubscriptionsAvailable != null && this.validProperties.contains((byte)40)) {
                outputStream2.write(40);
                outputStream2.writeBoolean(this.wildcardSubscriptionsAvailable);
            }
            if (this.subscriptionIdentifiersAvailable != null && this.validProperties.contains((byte)41)) {
                outputStream2.write(41);
                outputStream2.writeBoolean(this.subscriptionIdentifiersAvailable);
            }
            if (this.sharedSubscriptionAvailable != null && this.validProperties.contains((byte)42)) {
                outputStream2.write(42);
                outputStream2.writeBoolean(this.sharedSubscriptionAvailable);
            }
            int length = outputStream2.size();
            outputStream2.flush();
            ByteArrayOutputStream finalOutput = new ByteArrayOutputStream();
            finalOutput.write(MqttDataTypes.encodeVariableByteInteger(length));
            finalOutput.write(baos.toByteArray());
            return finalOutput.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public void decodeProperties(DataInputStream dis) throws IOException, MqttException {
        int length = MqttDataTypes.readVariableByteInteger(dis).getValue();
        if (length > 0) {
            byte[] identifierValueByteArray = new byte[length];
            dis.read(identifierValueByteArray, 0, length);
            ByteArrayInputStream bais = new ByteArrayInputStream(identifierValueByteArray);
            ArrayList<Byte> decodedProperties = new ArrayList<Byte>();
            DataInputStream inputStream2 = new DataInputStream(bais);
            while (inputStream2.available() > 0) {
                byte identifier = inputStream2.readByte();
                if (this.validProperties.contains(identifier)) {
                    if (!decodedProperties.contains(identifier)) {
                        decodedProperties.add(identifier);
                    } else if (identifier != 11 && identifier != 38) {
                        throw new MqttException(50005);
                    }
                    if (identifier == 1) {
                        this.payloadFormat = inputStream2.readBoolean();
                        continue;
                    }
                    if (identifier == 2) {
                        this.messageExpiryInterval = MqttDataTypes.readUnsignedFourByteInt(inputStream2);
                        continue;
                    }
                    if (identifier == 3) {
                        this.contentType = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 8) {
                        this.responseTopic = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 9) {
                        short correlationDataLength = inputStream2.readShort();
                        this.correlationData = new byte[correlationDataLength];
                        inputStream2.read(this.correlationData, 0, correlationDataLength);
                        continue;
                    }
                    if (identifier == 11) {
                        int subscriptionIdentifier = MqttDataTypes.readVariableByteInteger(inputStream2).getValue();
                        this.publishSubscriptionIdentifiers.add(subscriptionIdentifier);
                        this.subscribeSubscriptionIdentifier = subscriptionIdentifier;
                        continue;
                    }
                    if (identifier == 17) {
                        this.sessionExpiryInterval = MqttDataTypes.readUnsignedFourByteInt(inputStream2);
                        continue;
                    }
                    if (identifier == 18) {
                        this.assignedClientIdentifier = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 19) {
                        this.serverKeepAlive = MqttDataTypes.readUnsignedTwoByteInt(inputStream2);
                        continue;
                    }
                    if (identifier == 21) {
                        this.authenticationMethod = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 22) {
                        short authDataLength = inputStream2.readShort();
                        this.authenticationData = new byte[authDataLength];
                        inputStream2.read(this.authenticationData, 0, authDataLength);
                        continue;
                    }
                    if (identifier == 23) {
                        this.requestProblemInfo = inputStream2.read() != 0;
                        continue;
                    }
                    if (identifier == 24) {
                        this.willDelayInterval = MqttDataTypes.readUnsignedFourByteInt(inputStream2);
                        continue;
                    }
                    if (identifier == 25) {
                        this.requestResponseInfo = inputStream2.read() != 0;
                        continue;
                    }
                    if (identifier == 26) {
                        this.responseInfo = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 28) {
                        this.serverReference = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 31) {
                        this.reasonString = MqttDataTypes.decodeUTF8(inputStream2);
                        continue;
                    }
                    if (identifier == 33) {
                        this.receiveMaximum = inputStream2.readShort();
                        continue;
                    }
                    if (identifier == 34) {
                        this.topicAliasMaximum = inputStream2.readShort();
                        continue;
                    }
                    if (identifier == 35) {
                        this.topicAlias = inputStream2.readShort();
                        continue;
                    }
                    if (identifier == 36) {
                        this.maximumQoS = inputStream2.read();
                        continue;
                    }
                    if (identifier == 37) {
                        this.retainAvailable = inputStream2.readBoolean();
                        continue;
                    }
                    if (identifier == 38) {
                        String key2 = MqttDataTypes.decodeUTF8(inputStream2);
                        String value2 = MqttDataTypes.decodeUTF8(inputStream2);
                        this.userProperties.add(new UserProperty(key2, value2));
                        continue;
                    }
                    if (identifier == 39) {
                        this.maximumPacketSize = MqttDataTypes.readUnsignedFourByteInt(inputStream2);
                        continue;
                    }
                    if (identifier == 40) {
                        this.wildcardSubscriptionsAvailable = inputStream2.readBoolean();
                        continue;
                    }
                    if (identifier == 41) {
                        this.subscriptionIdentifiersAvailable = inputStream2.readBoolean();
                        continue;
                    }
                    if (identifier == 42) {
                        this.sharedSubscriptionAvailable = inputStream2.readBoolean();
                        continue;
                    }
                    inputStream2.close();
                    throw new MqttException(50000);
                }
                inputStream2.close();
                throw new MqttException(50000);
            }
        }
    }

    public List<Byte> getValidProperties() {
        return this.validProperties;
    }

    public Boolean requestResponseInfo() {
        return this.requestResponseInfo;
    }

    public void setRequestResponseInfo(Boolean requestResponseInfo) {
        this.requestResponseInfo = requestResponseInfo;
    }

    public Boolean requestProblemInfo() {
        return this.requestProblemInfo;
    }

    public void setRequestProblemInfo(Boolean requestProblemInfo) {
        this.requestProblemInfo = requestProblemInfo;
    }

    public Long getWillDelayInterval() {
        return this.willDelayInterval;
    }

    public void setWillDelayInterval(Long willDelayInterval) {
        MqttDataTypes.validateFourByteInt(willDelayInterval);
        this.willDelayInterval = willDelayInterval;
    }

    public Integer getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(Integer receiveMaximum) {
        MqttDataTypes.validateTwoByteInt(receiveMaximum);
        this.receiveMaximum = receiveMaximum;
    }

    public Integer getMaximumQoS() {
        return this.maximumQoS;
    }

    public void setMaximumQoS(Integer maximumQoS) {
        this.maximumQoS = maximumQoS;
    }

    public Long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(Long maximumPacketSize) {
        MqttDataTypes.validateFourByteInt(maximumPacketSize);
        this.maximumPacketSize = maximumPacketSize;
    }

    public Boolean isRetainAvailable() {
        if (this.retainAvailable == null || this.retainAvailable.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setRetainAvailable(boolean retainAvailable) {
        this.retainAvailable = retainAvailable;
    }

    public String getAssignedClientIdentifier() {
        return this.assignedClientIdentifier;
    }

    public void setAssignedClientIdentifier(String assignedClientIdentifier) {
        this.assignedClientIdentifier = assignedClientIdentifier;
    }

    public Integer getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public void setTopicAliasMaximum(Integer topicAliasMaximum) {
        MqttDataTypes.validateTwoByteInt(topicAliasMaximum);
        this.topicAliasMaximum = topicAliasMaximum;
    }

    public Integer getTopicAlias() {
        return this.topicAlias;
    }

    public void setTopicAlias(Integer topicAlias) {
        MqttDataTypes.validateTwoByteInt(topicAlias);
        this.topicAlias = topicAlias;
    }

    public Integer getServerKeepAlive() {
        return this.serverKeepAlive;
    }

    public void setServerKeepAlive(Integer serverKeepAlive) {
        MqttDataTypes.validateTwoByteInt(serverKeepAlive);
        this.serverKeepAlive = serverKeepAlive;
    }

    public String getResponseInfo() {
        return this.responseInfo;
    }

    public void setResponseInfo(String responseInfo) {
        this.responseInfo = responseInfo;
    }

    public String getServerReference() {
        return this.serverReference;
    }

    public void setServerReference(String serverReference) {
        this.serverReference = serverReference;
    }

    public boolean isWildcardSubscriptionsAvailable() {
        return this.wildcardSubscriptionsAvailable == null || this.wildcardSubscriptionsAvailable != false;
    }

    public void setWildcardSubscriptionsAvailable(boolean wildcardSubscriptionsAvailable) {
        this.wildcardSubscriptionsAvailable = wildcardSubscriptionsAvailable;
    }

    public boolean isSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable == null || this.subscriptionIdentifiersAvailable != false;
    }

    public void setSubscriptionIdentifiersAvailable(boolean subscriptionIdentifiersAvailable) {
        this.subscriptionIdentifiersAvailable = subscriptionIdentifiersAvailable;
    }

    public boolean isSharedSubscriptionAvailable() {
        return this.sharedSubscriptionAvailable == null || this.sharedSubscriptionAvailable != false;
    }

    public void setSharedSubscriptionAvailable(boolean sharedSubscriptionAvailable) {
        this.sharedSubscriptionAvailable = sharedSubscriptionAvailable;
    }

    public Long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public void setSessionExpiryInterval(Long sessionExpiryInterval) {
        MqttDataTypes.validateFourByteInt(sessionExpiryInterval);
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public byte[] getAuthenticationData() {
        return this.authenticationData;
    }

    public void setAuthenticationData(byte[] authenticationData) {
        this.authenticationData = authenticationData;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public void setReasonString(String reasonString) {
        this.reasonString = reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
    }

    public boolean getPayloadFormat() {
        return this.payloadFormat;
    }

    public void setPayloadFormat(boolean payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public Long getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public void setMessageExpiryInterval(Long messageExpiryInterval) {
        MqttDataTypes.validateFourByteInt(messageExpiryInterval);
        this.messageExpiryInterval = messageExpiryInterval;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType2) {
        this.contentType = contentType2;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public void setResponseTopic(String responseTopic) {
        if (responseTopic != null) {
            MqttTopicValidator.validate(responseTopic, false, true);
        }
        this.responseTopic = responseTopic;
    }

    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    public void setCorrelationData(byte[] correlationData) {
        this.correlationData = correlationData;
    }

    public List<Integer> getSubscriptionIdentifiers() {
        return this.publishSubscriptionIdentifiers;
    }

    public void setSubscriptionIdentifiers(List<Integer> subscriptionIdentifiers) {
        for (Integer subId : subscriptionIdentifiers) {
            MqttDataTypes.validateVariableByteInt(subId);
        }
        this.publishSubscriptionIdentifiers = subscriptionIdentifiers;
    }

    public Integer getSubscriptionIdentifier() {
        return this.subscribeSubscriptionIdentifier;
    }

    public void setSubscriptionIdentifier(Integer subscriptionIdentifier) {
        MqttDataTypes.validateVariableByteInt(subscriptionIdentifier);
        this.subscribeSubscriptionIdentifier = subscriptionIdentifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MqttProperties [validProperties=" + this.validProperties);
        if (this.requestResponseInfo != null) {
            sb.append(", requestResponseInfo=" + this.requestResponseInfo);
        }
        if (this.requestProblemInfo != null) {
            sb.append(", requestProblemInfo=" + this.requestProblemInfo);
        }
        if (this.willDelayInterval != null) {
            sb.append(", willDelayInterval=" + this.willDelayInterval);
        }
        if (this.receiveMaximum != null) {
            sb.append(", receiveMaximum=" + this.receiveMaximum);
        }
        if (this.maximumQoS != null) {
            sb.append(", maximumQoS=" + this.maximumQoS);
        }
        if (this.maximumPacketSize != null) {
            sb.append(", maximumPacketSize=" + this.maximumPacketSize);
        }
        if (this.retainAvailable != null) {
            sb.append(", retainAvailable=" + this.retainAvailable);
        }
        if (this.assignedClientIdentifier != null) {
            sb.append(", assignedClientIdentifier=" + this.assignedClientIdentifier);
        }
        if (this.topicAliasMaximum != null) {
            sb.append(", topicAliasMaximum=" + this.topicAliasMaximum);
        }
        if (this.topicAlias != null) {
            sb.append(", topicAlias=" + this.topicAlias);
        }
        if (this.serverKeepAlive != null) {
            sb.append(", serverKeepAlive=" + this.serverKeepAlive);
        }
        if (this.responseInfo != null) {
            sb.append(", responseInfo=" + this.responseInfo);
        }
        if (this.serverReference != null) {
            sb.append(", serverReference=" + this.serverReference);
        }
        if (this.wildcardSubscriptionsAvailable != null) {
            sb.append(", wildcardSubscriptionsAvailable=" + this.wildcardSubscriptionsAvailable);
        }
        if (this.subscriptionIdentifiersAvailable != null) {
            sb.append(", subscriptionIdentifiersAvailable=" + this.subscriptionIdentifiersAvailable);
        }
        if (this.sharedSubscriptionAvailable != null) {
            sb.append(", sharedSubscriptionAvailable=" + this.sharedSubscriptionAvailable);
        }
        if (this.sessionExpiryInterval != null) {
            sb.append(", sessionExpiryInterval=" + this.sessionExpiryInterval);
        }
        if (this.authenticationMethod != null) {
            sb.append(", authenticationMethod=" + this.authenticationMethod);
        }
        if (this.authenticationData != null) {
            sb.append(", authenticationData=" + Arrays.toString(this.authenticationData));
        }
        if (this.reasonString != null) {
            sb.append(", reasonString=" + this.reasonString);
        }
        if (this.userProperties != null && this.userProperties.size() != 0) {
            sb.append(", userProperties=" + this.userProperties);
        }
        if (this.payloadFormat.booleanValue()) {
            sb.append(", isUTF8=" + this.payloadFormat);
        }
        if (this.messageExpiryInterval != null) {
            sb.append(", messageExpiryInterval=" + this.messageExpiryInterval);
        }
        if (this.contentType != null) {
            sb.append(", contentType=" + this.contentType);
        }
        if (this.responseTopic != null) {
            sb.append(", responseTopic=" + this.responseTopic);
        }
        if (this.correlationData != null) {
            sb.append(", correlationData=" + Arrays.toString(this.correlationData));
        }
        if (this.publishSubscriptionIdentifiers.size() != 0) {
            sb.append(", subscriptionIdentifiers=" + this.publishSubscriptionIdentifiers);
        }
        sb.append("]");
        return sb.toString();
    }
}

