/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.tomlj.JsonOptions;
import org.tomlj.TomlArray;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;

final class JsonSerializer {
    private JsonSerializer() {
    }

    static void toJson(TomlTable table, Appendable appendable, Set<JsonOptions> options2) throws IOException {
        Objects.requireNonNull(table);
        Objects.requireNonNull(appendable);
        JsonSerializer.toJson(table, appendable, options2, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlTable table, Appendable appendable, Set<JsonOptions> options2, int indent2) throws IOException {
        if (table.isEmpty()) {
            appendable.append("{}");
            return;
        }
        JsonSerializer.appendLine(appendable, "{");
        Iterator iterator2 = table.entrySet().stream().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            String key2 = (String)entry.getKey();
            JsonSerializer.append(appendable, indent2 + 2, "\"" + JsonSerializer.escape(key2) + "\" : ");
            Object value2 = entry.getValue();
            assert (value2 != null);
            JsonSerializer.appendTomlValue(value2, appendable, options2, indent2);
            if (!iterator2.hasNext()) continue;
            appendable.append(",");
            appendable.append(System.lineSeparator());
        }
        appendable.append(System.lineSeparator());
        JsonSerializer.append(appendable, indent2, "}");
    }

    static void toJson(TomlArray array, Appendable appendable, Set<JsonOptions> options2) throws IOException {
        JsonSerializer.toJson(array, appendable, options2, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlArray array, Appendable appendable, Set<JsonOptions> options2, int indent2) throws IOException {
        if (array.isEmpty()) {
            appendable.append("[]");
            return;
        }
        appendable.append("[");
        Optional<Object> tomlType = Optional.empty();
        Iterator<Object> iterator2 = array.toList().iterator();
        while (iterator2.hasNext()) {
            Object tomlValue = iterator2.next();
            tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) {
                JsonSerializer.toJson((TomlTable)tomlValue, appendable, options2, indent2);
            } else {
                appendable.append(System.lineSeparator());
                JsonSerializer.indentLine(appendable, indent2 + 2);
                JsonSerializer.appendTomlValue(tomlValue, appendable, options2, indent2);
            }
            if (iterator2.hasNext()) {
                appendable.append(",");
                continue;
            }
            if (((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) continue;
            appendable.append(System.lineSeparator());
        }
        if (tomlType.isPresent() && ((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) {
            appendable.append("]");
        } else {
            JsonSerializer.append(appendable, indent2, "]");
        }
    }

    private static void appendTomlValue(Object value2, Appendable appendable, Set<JsonOptions> options2, int indent2) throws IOException {
        Optional<TomlType> tomlType = TomlType.typeFor(value2);
        assert (tomlType.isPresent());
        switch (tomlType.get()) {
            case ARRAY: {
                JsonSerializer.toJson((TomlArray)value2, appendable, options2, indent2 + 2);
                return;
            }
            case TABLE: {
                JsonSerializer.toJson((TomlTable)value2, appendable, options2, indent2 + 2);
                return;
            }
        }
        if (options2.contains((Object)JsonOptions.VALUES_AS_OBJECTS_WITH_TYPE)) {
            appendable.append("{ \"type\": \"");
            appendable.append(JsonSerializer.typeName(tomlType.get()));
            appendable.append("\", \"value\": ");
            JsonSerializer.appendTomlValueLiteral(tomlType.get(), value2, appendable, options2);
            appendable.append(" }");
        } else {
            JsonSerializer.appendTomlValueLiteral(tomlType.get(), value2, appendable, options2);
        }
    }

    private static String typeName(TomlType tomlType) {
        switch (tomlType) {
            case BOOLEAN: {
                return "bool";
            }
            case OFFSET_DATE_TIME: {
                return "datetime";
            }
            case LOCAL_DATE_TIME: {
                return "datetime-local";
            }
            case LOCAL_DATE: {
                return "date-local";
            }
            case LOCAL_TIME: {
                return "time-local";
            }
        }
        return tomlType.typeName();
    }

    private static void appendTomlValueLiteral(TomlType tomlType, Object value2, Appendable appendable, Set<JsonOptions> options2) throws IOException {
        switch (tomlType) {
            case STRING: {
                appendable.append('\"');
                appendable.append(JsonSerializer.escape((String)value2));
                appendable.append('\"');
                break;
            }
            case INTEGER: {
                if (options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                appendable.append(value2.toString());
                if (!options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case FLOAT: {
                if (options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                if (Double.isNaN((Double)value2)) {
                    appendable.append("nan");
                } else if ((Double)value2 == Double.POSITIVE_INFINITY) {
                    appendable.append("+inf");
                } else if ((Double)value2 == Double.NEGATIVE_INFINITY) {
                    appendable.append("-inf");
                } else {
                    appendable.append(value2.toString());
                }
                if (!options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case BOOLEAN: {
                if (options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                appendable.append((Boolean)value2 != false ? "true" : "false");
                if (!options2.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case OFFSET_DATE_TIME: {
                appendable.append('\"');
                appendable.append(((OffsetDateTime)value2).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
                appendable.append('\"');
                break;
            }
            case LOCAL_DATE_TIME: {
                appendable.append('\"');
                appendable.append(((LocalDateTime)value2).format(DateTimeFormatter.ISO_DATE_TIME));
                appendable.append('\"');
                break;
            }
            case LOCAL_DATE: {
                appendable.append('\"');
                appendable.append(((LocalDate)value2).format(DateTimeFormatter.ISO_DATE));
                appendable.append('\"');
                break;
            }
            case LOCAL_TIME: {
                appendable.append('\"');
                appendable.append(((LocalTime)value2).format(DateTimeFormatter.ISO_TIME));
                appendable.append('\"');
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to output literal form of non-literal type " + tomlType.typeName()));
            }
        }
    }

    private static void append(Appendable appendable, int indent2, String line) throws IOException {
        JsonSerializer.indentLine(appendable, indent2);
        appendable.append(line);
    }

    private static void appendLine(Appendable appendable, String line) throws IOException {
        appendable.append(line);
        appendable.append(System.lineSeparator());
    }

    private static void indentLine(Appendable appendable, int indent2) throws IOException {
        for (int i = 0; i < indent2; ++i) {
            appendable.append(' ');
        }
    }

    private static StringBuilder escape(String text) {
        StringBuilder out2 = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                out2.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                out2.append("\\\\");
                continue;
            }
            if (ch >= ' ') {
                out2.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out2.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out2.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out2.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out2.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out2.append("\\f");
                    continue block7;
                }
                default: {
                    out2.append("\\u").append(String.format("%04x", text.codePointAt(i)));
                }
            }
        }
        return out2;
    }
}

