/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.time.LocalTime;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.tomlj.TomlParseError;
import org.tomlj.TomlPosition;
import org.tomlj.internal.TomlParser;
import org.tomlj.internal.TomlParserBaseVisitor;

final class LocalTimeVisitor
extends TomlParserBaseVisitor<LocalTime> {
    private LocalTime time = LocalTime.MIN;

    LocalTimeVisitor() {
    }

    @Override
    public LocalTime visitHour(TomlParser.HourContext ctx) {
        int hour2;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        try {
            hour2 = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid hour", new TomlPosition(ctx), e);
        }
        if (hour2 < 0 || hour2 > 23) {
            throw new TomlParseError("Invalid hour (valid range 00..23)", new TomlPosition(ctx));
        }
        this.time = this.time.withHour(hour2);
        return this.time;
    }

    @Override
    public LocalTime visitMinute(TomlParser.MinuteContext ctx) {
        int minute2;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            minute2 = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid minutes", new TomlPosition(ctx), e);
        }
        if (minute2 < 0 || minute2 > 59) {
            throw new TomlParseError("Invalid minutes (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withMinute(minute2);
        return this.time;
    }

    @Override
    public LocalTime visitSecond(TomlParser.SecondContext ctx) {
        int second2;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        try {
            second2 = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid seconds", new TomlPosition(ctx), e);
        }
        if (second2 < 0 || second2 > 59) {
            throw new TomlParseError("Invalid seconds (valid range 00..59)", new TomlPosition(ctx));
        }
        this.time = this.time.withSecond(second2);
        return this.time;
    }

    @Override
    public LocalTime visitSecondFraction(TomlParser.SecondFractionContext ctx) {
        int nano;
        String text = ctx.getText();
        if (text.isEmpty() || text.length() > 9) {
            throw new TomlParseError("Invalid nanoseconds (valid range 0..999999999)", new TomlPosition(ctx));
        }
        if (text.length() < 9) {
            text = text + "000000000".substring(text.length());
        }
        try {
            nano = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid nanoseconds", new TomlPosition(ctx), e);
        }
        this.time = this.time.withNano(nano);
        return this.time;
    }

    @Override
    public LocalTime visitErrorNode(ErrorNode node2) {
        return null;
    }

    @Override
    protected LocalTime aggregateResult(LocalTime aggregate, LocalTime nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected LocalTime defaultResult() {
        return this.time;
    }
}

