/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.tomlj.Parser;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;
import org.tomlj.TomlVersion;

public final class Toml {
    private static final Pattern simpleKeyPattern = Pattern.compile("^[A-Za-z0-9_-]+$");

    private Toml() {
    }

    public static TomlParseResult parse(String input) {
        return Toml.parse(input, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(String input, TomlVersion version) {
        CodePointCharStream stream = CharStreams.fromString(input);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(Path file) throws IOException {
        return Toml.parse(file, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(Path file, TomlVersion version) throws IOException {
        CharsetDecoder decoder2 = StandardCharsets.UTF_8.newDecoder();
        decoder2.onMalformedInput(CodingErrorAction.REPORT);
        decoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), decoder2);
        return Toml.parse(reader, version);
    }

    public static TomlParseResult parse(InputStream is) throws IOException {
        return Toml.parse(is, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(InputStream is, TomlVersion version) throws IOException {
        CharsetDecoder decoder2 = StandardCharsets.UTF_8.newDecoder();
        decoder2.onMalformedInput(CodingErrorAction.REPORT);
        decoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
        return Toml.parse(new InputStreamReader(is, decoder2), version);
    }

    public static TomlParseResult parse(Reader reader) throws IOException {
        return Toml.parse(reader, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(Reader reader, TomlVersion version) throws IOException {
        CodePointCharStream stream = CharStreams.fromReader(reader);
        return Parser.parse(stream, version.canonical);
    }

    public static TomlParseResult parse(ReadableByteChannel channel2) throws IOException {
        return Toml.parse(channel2, TomlVersion.LATEST);
    }

    public static TomlParseResult parse(ReadableByteChannel channel2, TomlVersion version) throws IOException {
        CodePointCharStream stream = CharStreams.fromChannel(channel2, StandardCharsets.UTF_8, 4096, CodingErrorAction.REPORT, "<unknown>", -1L);
        return Parser.parse(stream, version.canonical);
    }

    public static List<String> parseDottedKey(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return Parser.parseDottedKey(dottedKey);
    }

    public static String joinKeyPath(List<String> path) {
        Objects.requireNonNull(path);
        StringJoiner joiner = new StringJoiner(".");
        for (String key2 : path) {
            if (simpleKeyPattern.matcher(key2).matches()) {
                joiner.add(key2);
                continue;
            }
            joiner.add("\"" + Toml.tomlEscape(key2) + '\"');
        }
        return joiner.toString();
    }

    public static String canonicalDottedKey(String dottedKey) {
        return Toml.joinKeyPath(Toml.parseDottedKey(dottedKey));
    }

    public static StringBuilder tomlEscape(String text) {
        StringBuilder out2 = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            int codepoint = text.codePointAt(i);
            if (Character.charCount(codepoint) > 1) {
                out2.append("\\U").append(String.format("%08x", codepoint));
                ++i;
                continue;
            }
            char ch = Character.toChars(codepoint)[0];
            if (ch == '\'') {
                out2.append("\\'");
                continue;
            }
            if (ch == '\"') {
                out2.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                out2.append("\\\\");
                continue;
            }
            if (ch >= ' ' && ch < '\u007f') {
                out2.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out2.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out2.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out2.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out2.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out2.append("\\f");
                    continue block7;
                }
                default: {
                    out2.append("\\u").append(String.format("%04x", codepoint));
                }
            }
        }
        return out2;
    }

    public static boolean equals(TomlArray array1, TomlArray array2) {
        if (array1.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < array1.size(); ++i) {
            Object value1 = array1.get(i);
            Object value2 = array2.get(i);
            Optional<TomlType> tomlType1 = TomlType.typeFor(value1);
            assert (tomlType1.isPresent());
            Optional<TomlType> tomlType2 = TomlType.typeFor(value2);
            assert (tomlType2.isPresent());
            if (tomlType1.get() != tomlType2.get()) {
                return false;
            }
            if (!(tomlType1.get().equals((Object)TomlType.TABLE) ? !Toml.equals((TomlTable)value1, (TomlTable)value2) : (tomlType1.get().equals((Object)TomlType.ARRAY) ? !Toml.equals((TomlArray)value1, (TomlArray)value2) : !value1.equals(value2)))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(TomlTable table1, TomlTable table2) {
        if (table1.entrySet().size() != table2.entrySet().size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : table1.entrySet()) {
            String key2 = entry.getKey();
            if (!table2.keySet().contains(key2)) {
                return false;
            }
            Object value1 = entry.getValue();
            Optional<Map.Entry> value2Entry = table2.entrySet().stream().filter(entry2 -> ((String)entry2.getKey()).equals(key2)).findFirst();
            if (!value2Entry.isPresent()) {
                return false;
            }
            Object value2 = value2Entry.get().getValue();
            Optional<TomlType> tomlType1 = TomlType.typeFor(value1);
            assert (tomlType1.isPresent());
            Optional<TomlType> tomlType2 = TomlType.typeFor(value2);
            assert (tomlType2.isPresent());
            if (tomlType1.get() != tomlType2.get()) {
                return false;
            }
            if (!(tomlType1.get().equals((Object)TomlType.TABLE) ? !Toml.equals((TomlTable)value1, (TomlTable)value2) : (tomlType1.get().equals((Object)TomlType.ARRAY) ? !Toml.equals((TomlArray)value1, (TomlArray)value2) : !value1.equals(value2)))) continue;
            return false;
        }
        return true;
    }
}

