/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.List;
import org.tomlj.JsonOptions;
import org.tomlj.JsonSerializer;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlPosition;
import org.tomlj.TomlSerializer;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;

public interface TomlArray {
    public int size();

    public boolean isEmpty();

    public boolean containsStrings();

    public boolean containsLongs();

    public boolean containsDoubles();

    public boolean containsBooleans();

    public boolean containsOffsetDateTimes();

    public boolean containsLocalDateTimes();

    public boolean containsLocalDates();

    public boolean containsLocalTimes();

    public boolean containsArrays();

    public boolean containsTables();

    public Object get(int var1);

    public TomlPosition inputPositionOf(int var1);

    default public String getString(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof String)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (String)value2;
    }

    default public long getLong(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof Long)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (Long)value2;
    }

    default public double getDouble(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof Double)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (Double)value2;
    }

    default public boolean getBoolean(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof Boolean)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (Boolean)value2;
    }

    default public OffsetDateTime getOffsetDateTime(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof OffsetDateTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (OffsetDateTime)value2;
    }

    default public LocalDateTime getLocalDateTime(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof LocalDateTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (LocalDateTime)value2;
    }

    default public LocalDate getLocalDate(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof LocalDate)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (LocalDate)value2;
    }

    default public LocalTime getLocalTime(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof LocalTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (LocalTime)value2;
    }

    default public TomlArray getArray(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof TomlArray)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (TomlArray)value2;
    }

    default public TomlTable getTable(int index) {
        Object value2 = this.get(index);
        if (!(value2 instanceof TomlTable)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value2));
        }
        return (TomlTable)value2;
    }

    public List<Object> toList();

    default public String toJson(JsonOptions ... options2) {
        return this.toJson(JsonOptions.setFrom(options2));
    }

    default public String toJson(EnumSet<JsonOptions> options2) {
        StringBuilder builder = new StringBuilder();
        try {
            this.toJson((Appendable)builder, options2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toJson(Appendable appendable, JsonOptions ... options2) throws IOException {
        this.toJson(appendable, JsonOptions.setFrom(options2));
    }

    default public void toJson(Appendable appendable, EnumSet<JsonOptions> options2) throws IOException {
        JsonSerializer.toJson(this, appendable, options2);
    }

    default public String toToml() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toToml(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toToml(Appendable appendable) throws IOException {
        TomlSerializer.toToml(this, appendable);
    }
}

