/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;

final class TomlSerializer {
    private TomlSerializer() {
    }

    static void toToml(TomlTable table, Appendable appendable) throws IOException {
        Objects.requireNonNull(table);
        Objects.requireNonNull(appendable);
        TomlSerializer.toToml(table, appendable, -2, "");
    }

    private static void toToml(TomlTable table, Appendable appendable, int indent2, String path) throws IOException {
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            boolean isTableArray;
            String key2 = entry.getKey();
            Object value2 = entry.getValue();
            if (!(key2 = Toml.tomlEscape(key2).toString()).matches("[a-zA-Z0-9_-]*")) {
                key2 = "\"" + key2 + "\"";
            }
            String newPath = (path.isEmpty() ? "" : path + ".") + key2;
            Optional<TomlType> tomlType = TomlType.typeFor(value2);
            assert (tomlType.isPresent());
            boolean bl = isTableArray = tomlType.get().equals((Object)TomlType.ARRAY) && TomlSerializer.isTableArray((TomlArray)value2);
            if (tomlType.get().equals((Object)TomlType.TABLE)) {
                TomlSerializer.append(appendable, indent2 + 2, "[" + newPath + "]");
                appendable.append(System.lineSeparator());
            } else if (!isTableArray) {
                TomlSerializer.append(appendable, indent2 + 2, key2 + "=");
            }
            TomlSerializer.appendTomlValue(value2, appendable, indent2, newPath);
            if (tomlType.get().equals((Object)TomlType.TABLE) || isTableArray) continue;
            appendable.append(System.lineSeparator());
        }
    }

    static void toToml(TomlArray array, Appendable appendable) throws IOException {
        Objects.requireNonNull(array);
        Objects.requireNonNull(appendable);
        TomlSerializer.toToml(array, appendable, 0, "");
    }

    private static void toToml(TomlArray array, Appendable appendable, int indent2, String path) throws IOException {
        boolean tableArray = TomlSerializer.isTableArray(array);
        if (!tableArray) {
            appendable.append("[");
            if (!array.isEmpty()) {
                appendable.append(System.lineSeparator());
            }
        }
        Iterator<Object> iterator2 = array.toList().iterator();
        while (iterator2.hasNext()) {
            Object tomlValue = iterator2.next();
            Optional<TomlType> tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (tomlType.get().equals((Object)TomlType.TABLE)) {
                TomlSerializer.append(appendable, indent2, "[[" + path + "]]");
                appendable.append(System.lineSeparator());
                TomlSerializer.toToml((TomlTable)tomlValue, appendable, indent2, path);
            } else {
                TomlSerializer.indentLine(appendable, indent2 + 2);
                TomlSerializer.appendTomlValue(tomlValue, appendable, indent2, path);
            }
            if (tableArray) continue;
            if (iterator2.hasNext()) {
                appendable.append(",");
            }
            appendable.append(System.lineSeparator());
        }
        if (!tableArray) {
            TomlSerializer.append(appendable, indent2, "]");
        }
    }

    private static void appendTomlValue(Object value2, Appendable appendable, int indent2, String path) throws IOException {
        Optional<TomlType> tomlType = TomlType.typeFor(value2);
        assert (tomlType.isPresent());
        switch (tomlType.get()) {
            case STRING: {
                TomlSerializer.append(appendable, 0, "\"" + Toml.tomlEscape((String)value2) + "\"");
                break;
            }
            case INTEGER: 
            case FLOAT: {
                TomlSerializer.append(appendable, 0, value2.toString());
                break;
            }
            case OFFSET_DATE_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)value2));
                break;
            }
            case LOCAL_DATE_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)value2));
                break;
            }
            case LOCAL_DATE: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)value2));
                break;
            }
            case LOCAL_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)value2));
                break;
            }
            case BOOLEAN: {
                TomlSerializer.append(appendable, 0, (Boolean)value2 != false ? "true" : "false");
                break;
            }
            case ARRAY: {
                TomlSerializer.toToml((TomlArray)value2, appendable, indent2 + 2, path);
                break;
            }
            case TABLE: {
                TomlSerializer.toToml((TomlTable)value2, appendable, indent2 + 2, path);
            }
        }
    }

    private static void append(Appendable appendable, int indent2, String line) throws IOException {
        TomlSerializer.indentLine(appendable, indent2);
        appendable.append(line);
    }

    private static void indentLine(Appendable appendable, int indent2) throws IOException {
        for (int i = 0; i < indent2; ++i) {
            appendable.append(' ');
        }
    }

    private static boolean isTableArray(TomlArray array) {
        for (Object tomlValue : array.toList()) {
            Optional<TomlType> tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (!tomlType.get().equals((Object)TomlType.TABLE)) continue;
            return true;
        }
        return false;
    }
}

