/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tomlj.EmptyTomlArray;
import org.tomlj.EmptyTomlTable;
import org.tomlj.JsonOptions;
import org.tomlj.JsonSerializer;
import org.tomlj.Parser;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlPosition;
import org.tomlj.TomlSerializer;
import org.tomlj.TomlType;

public interface TomlTable {
    public int size();

    public boolean isEmpty();

    default public boolean contains(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.contains(Parser.parseDottedKey(dottedKey));
    }

    default public boolean contains(List<String> path) {
        try {
            return this.get(path) != null;
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
    }

    public Set<String> keySet();

    default public Set<String> dottedKeySet() {
        return this.keyPathSet().stream().map(Toml::joinKeyPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<String> dottedKeySet(boolean includeTables) {
        return this.keyPathSet(includeTables).stream().map(Toml::joinKeyPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<List<String>> keyPathSet() {
        return this.keyPathSet(false);
    }

    public Set<List<String>> keyPathSet(boolean var1);

    public Set<Map.Entry<String, Object>> entrySet();

    default public Set<Map.Entry<String, Object>> dottedEntrySet() {
        return this.entryPathSet().stream().map(e -> new AbstractMap.SimpleEntry(Toml.joinKeyPath((List)e.getKey()), e.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<Map.Entry<String, Object>> dottedEntrySet(boolean includeTables) {
        return this.entryPathSet(includeTables).stream().map(e -> new AbstractMap.SimpleEntry(Toml.joinKeyPath((List)e.getKey()), e.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<Map.Entry<List<String>, Object>> entryPathSet() {
        return this.entryPathSet(false);
    }

    public Set<Map.Entry<List<String>, Object>> entryPathSet(boolean var1);

    default public @Nullable Object get(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.get(Parser.parseDottedKey(dottedKey));
    }

    public @Nullable Object get(List<String> var1);

    default public @Nullable TomlPosition inputPositionOf(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.inputPositionOf(Parser.parseDottedKey(dottedKey));
    }

    public @Nullable TomlPosition inputPositionOf(List<String> var1);

    default public boolean isString(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isString(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isString(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof String;
    }

    default public @Nullable String getString(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getString(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable String getString(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof String)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (String)value2;
    }

    default public String getString(String dottedKey, Supplier<String> defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getString(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public String getString(List<String> path, Supplier<String> defaultValue) {
        Objects.requireNonNull(defaultValue);
        String value2 = this.getString(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.get();
    }

    default public boolean isLong(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isLong(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isLong(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof Long;
    }

    default public @Nullable Long getLong(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getLong(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable Long getLong(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof Long)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (Long)value2;
    }

    default public long getLong(String dottedKey, LongSupplier defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getLong(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public long getLong(List<String> path, LongSupplier defaultValue) {
        Objects.requireNonNull(defaultValue);
        Long value2 = this.getLong(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.getAsLong();
    }

    default public boolean isDouble(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isDouble(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isDouble(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof Double;
    }

    default public @Nullable Double getDouble(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getDouble(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable Double getDouble(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof Double)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (Double)value2;
    }

    default public double getDouble(String dottedKey, DoubleSupplier defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getDouble(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public double getDouble(List<String> path, DoubleSupplier defaultValue) {
        Objects.requireNonNull(defaultValue);
        Double value2 = this.getDouble(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.getAsDouble();
    }

    default public boolean isBoolean(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isBoolean(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isBoolean(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof Boolean;
    }

    default public @Nullable Boolean getBoolean(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getBoolean(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable Boolean getBoolean(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof Boolean)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (Boolean)value2;
    }

    default public boolean getBoolean(String dottedKey, BooleanSupplier defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getBoolean(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public boolean getBoolean(List<String> path, BooleanSupplier defaultValue) {
        Objects.requireNonNull(defaultValue);
        Boolean value2 = this.getBoolean(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.getAsBoolean();
    }

    default public boolean isOffsetDateTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isOffsetDateTime(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isOffsetDateTime(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof OffsetDateTime;
    }

    default public @Nullable OffsetDateTime getOffsetDateTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getOffsetDateTime(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable OffsetDateTime getOffsetDateTime(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof OffsetDateTime)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (OffsetDateTime)value2;
    }

    default public OffsetDateTime getOffsetDateTime(String dottedKey, Supplier<OffsetDateTime> defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getOffsetDateTime(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public OffsetDateTime getOffsetDateTime(List<String> path, Supplier<OffsetDateTime> defaultValue) {
        Objects.requireNonNull(defaultValue);
        OffsetDateTime value2 = this.getOffsetDateTime(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.get();
    }

    default public boolean isLocalDateTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isLocalDateTime(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isLocalDateTime(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof LocalDateTime;
    }

    default public @Nullable LocalDateTime getLocalDateTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalDateTime(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable LocalDateTime getLocalDateTime(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof LocalDateTime)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (LocalDateTime)value2;
    }

    default public LocalDateTime getLocalDateTime(String dottedKey, Supplier<LocalDateTime> defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalDateTime(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public LocalDateTime getLocalDateTime(List<String> path, Supplier<LocalDateTime> defaultValue) {
        Objects.requireNonNull(defaultValue);
        LocalDateTime value2 = this.getLocalDateTime(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.get();
    }

    default public boolean isLocalDate(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isLocalDate(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isLocalDate(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof LocalDate;
    }

    default public @Nullable LocalDate getLocalDate(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalDate(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable LocalDate getLocalDate(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof LocalDate)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (LocalDate)value2;
    }

    default public LocalDate getLocalDate(String dottedKey, Supplier<LocalDate> defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalDate(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public LocalDate getLocalDate(List<String> path, Supplier<LocalDate> defaultValue) {
        Objects.requireNonNull(defaultValue);
        LocalDate value2 = this.getLocalDate(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.get();
    }

    default public boolean isLocalTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isLocalTime(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isLocalTime(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof LocalTime;
    }

    default public @Nullable LocalTime getLocalTime(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalTime(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable LocalTime getLocalTime(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof LocalTime)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (LocalTime)value2;
    }

    default public LocalTime getLocalTime(String dottedKey, Supplier<LocalTime> defaultValue) {
        Objects.requireNonNull(dottedKey);
        return this.getLocalTime(Parser.parseDottedKey(dottedKey), defaultValue);
    }

    default public LocalTime getLocalTime(List<String> path, Supplier<LocalTime> defaultValue) {
        Objects.requireNonNull(defaultValue);
        LocalTime value2 = this.getLocalTime(path);
        if (value2 != null) {
            return value2;
        }
        return defaultValue.get();
    }

    default public boolean isArray(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isArray(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isArray(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof TomlArray;
    }

    default public @Nullable TomlArray getArray(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getArray(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable TomlArray getArray(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof TomlArray)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (TomlArray)value2;
    }

    default public TomlArray getArrayOrEmpty(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getArrayOrEmpty(Parser.parseDottedKey(dottedKey));
    }

    default public TomlArray getArrayOrEmpty(List<String> path) {
        TomlArray value2 = this.getArray(path);
        if (value2 != null) {
            return value2;
        }
        return EmptyTomlArray.EMPTY_ARRAY;
    }

    default public boolean isTable(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.isTable(Parser.parseDottedKey(dottedKey));
    }

    default public boolean isTable(List<String> path) {
        Object value2;
        try {
            value2 = this.get(path);
        }
        catch (TomlInvalidTypeException e) {
            return false;
        }
        return value2 instanceof TomlTable;
    }

    default public @Nullable TomlTable getTable(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getTable(Parser.parseDottedKey(dottedKey));
    }

    default public @Nullable TomlTable getTable(List<String> path) {
        Object value2 = this.get(path);
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof TomlTable)) {
            throw new TomlInvalidTypeException("Value of '" + Toml.joinKeyPath(path) + "' is a " + TomlType.typeNameFor(value2));
        }
        return (TomlTable)value2;
    }

    default public TomlTable getTableOrEmpty(String dottedKey) {
        Objects.requireNonNull(dottedKey);
        return this.getTableOrEmpty(Parser.parseDottedKey(dottedKey));
    }

    default public TomlTable getTableOrEmpty(List<String> path) {
        TomlTable value2 = this.getTable(path);
        if (value2 != null) {
            return value2;
        }
        return EmptyTomlTable.EMPTY_TABLE;
    }

    public Map<String, Object> toMap();

    default public String toJson(JsonOptions ... options2) {
        return this.toJson(JsonOptions.setFrom(options2));
    }

    default public String toJson(EnumSet<JsonOptions> options2) {
        StringBuilder builder = new StringBuilder();
        try {
            this.toJson((Appendable)builder, options2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toJson(Appendable appendable, JsonOptions ... options2) throws IOException {
        this.toJson(appendable, JsonOptions.setFrom(options2));
    }

    default public void toJson(Appendable appendable, EnumSet<JsonOptions> options2) throws IOException {
        JsonSerializer.toJson(this, appendable, options2);
    }

    default public String toToml() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toToml(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toToml(Appendable appendable) throws IOException {
        TomlSerializer.toToml(this, appendable);
    }
}

