/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.config;

import com.datalogic.agent.config.Agent;
import com.datalogic.agent.config.Config;
import com.datalogic.agent.config.ConfigHelper;
import com.datalogic.agent.config.Edge;
import com.datalogic.agent.config.FileConf;
import com.datalogic.agent.config.LegacyConfig;
import com.datalogic.agent.config.LegacyFirmware;
import com.datalogic.agent.config.Mqtt;
import com.datalogic.agent.utils.FileUtilsKt;
import com.sksamuel.hoplite.ClasspathResourceLoader;
import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.ConfigLoader;
import com.sksamuel.hoplite.ConfigLoaderBuilder;
import com.sksamuel.hoplite.ConfigLoaderBuilderExtensionsKt;
import com.sksamuel.hoplite.ConfigSource;
import com.sksamuel.hoplite.DecoderContext;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.decoder.NonNullableLeafDecoder;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.preprocessor.RandomPreprocessor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000*\u0001\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/datalogic/agent/config/ConfigHelper;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "CONFIG_FILE_NAME", "", "CONFIG_VERSION", "", "config", "Lcom/datalogic/agent/config/Config;", "getConfig", "()Lcom/datalogic/agent/config/Config;", "config$delegate", "Lkotlin/Lazy;", "createLogLevelDecoder", "com/datalogic/agent/config/ConfigHelper$createLogLevelDecoder$1", "()Lcom/datalogic/agent/config/ConfigHelper$createLogLevelDecoder$1;", "migrateConfig", "configFile", "Ljava/io/File;", "parseMqttHost", "Lkotlin/Triple;", "host", "writeNewConfig", "", "dl-client-sdk"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/datalogic/agent/config/ConfigHelper\n+ 2 ConfigLoader.kt\ncom/sksamuel/hoplite/ConfigLoader\n*L\n1#1,223:1\n80#2,13:224\n126#2:237\n*S KotlinDebug\n*F\n+ 1 Config.kt\ncom/datalogic/agent/config/ConfigHelper\n*L\n101#1:224,13\n101#1:237\n*E\n"})
public final class ConfigHelper
implements Logging {
    @NotNull
    public static final ConfigHelper INSTANCE = new ConfigHelper();
    @NotNull
    public static final String CONFIG_FILE_NAME = "config.toml";
    public static final int CONFIG_VERSION = 2;
    @NotNull
    private static final Lazy config$delegate;

    private ConfigHelper() {
    }

    /*
     * WARNING - void declaration
     */
    private final Config migrateConfig(File configFile) {
        this.getLogger().info("Attempting to migrate legacy configuration...");
        try {
            void this_$iv;
            void resourceOrFiles$iv;
            ConfigLoader configLoader = ConfigLoaderBuilderExtensionsKt.addFileSource(ConfigLoaderBuilder.Companion.default(), CONFIG_FILE_NAME, false, false).addPreprocessor(RandomPreprocessor.INSTANCE).addDecoder(this.createLogLevelDecoder()).build();
            String[] stringArray = new String[]{};
            boolean $i$f$loadConfigOrThrow = false;
            List<String> resourceOrFiles$iv$iv = ArraysKt.toList(resourceOrFiles$iv);
            ClasspathResourceLoader classpathResourceLoader$iv$iv = ClasspathResourceLoader.Companion.toClasspathResourceLoader(ConfigSource.Companion.class);
            boolean $i$f$loadConfigOrThrow2 = false;
            void this_$iv$iv$iv = this_$iv;
            boolean $i$f$loadConfig = false;
            LegacyConfig legacyConfig = (LegacyConfig)this_$iv.returnOrThrow(this_$iv$iv$iv.loadConfig(Reflection.getOrCreateKotlinClass(LegacyConfig.class), CollectionsKt.emptyList(), resourceOrFiles$iv$iv, classpathResourceLoader$iv$iv));
            Integer n = legacyConfig.getVersion();
            this.getLogger().info("Detected legacy config version " + (n != null ? n : 1));
            Triple<String, Integer, String> mqttHostPort = this.parseMqttHost(legacyConfig.getMqtt().getHost());
            Object object = legacyConfig.getFirmware();
            if (object == null || (object = ((LegacyFirmware)object).getHost()) == null) {
                object = mqttHostPort.getFirst();
            }
            Object edgeHost = object;
            Agent agent = legacyConfig.getAgent();
            Mqtt mqtt = new Mqtt(legacyConfig.getMqtt().getClientId(), ((Number)mqttHostPort.getSecond()).intValue(), mqttHostPort.getThird(), legacyConfig.getMqtt().getUsername(), legacyConfig.getMqtt().getPassword(), legacyConfig.getMqtt().getCaFilePath(), legacyConfig.getMqtt().getCrtFilePath(), legacyConfig.getMqtt().getKeyFilePath());
            Object object2 = legacyConfig.getFirmware();
            if (object2 == null || (object2 = ((LegacyFirmware)object2).getProtocol()) == null) {
                object2 = "http";
            }
            LegacyFirmware legacyFirmware = legacyConfig.getFirmware();
            Object object3 = legacyConfig.getFirmware();
            Config newConfig = new Config(2, agent, mqtt, new FileConf((String)object2, object3 != null && (object3 = ((LegacyFirmware)object3).getPort()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 8090, legacyFirmware != null ? legacyFirmware.getDownloadTimeoutMs() : 60000L), legacyConfig.getService(), new Edge((String)edgeHost));
            File backupFile = new File("config.toml.v1.backup");
            FilesKt.copyTo$default(configFile, backupFile, true, 0, 4, null);
            this.getLogger().info("Backed up old configuration to " + backupFile.getName());
            this.writeNewConfig(configFile, newConfig);
            this.getLogger().info("Successfully migrated configuration to version 2");
            return newConfig;
        }
        catch (Exception e) {
            this.getLogger().error("Failed to migrate configuration: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private final Triple<String, Integer, String> parseMqttHost(String host) {
        Triple<String, Integer, String> triple;
        Regex regex = new Regex("^(tcp|ssl)://([^:]+):(\\d+)$");
        MatchResult match = Regex.find$default(regex, host, 0, 2, null);
        if (match != null) {
            String protocol = match.getGroupValues().get(1);
            String hostName = match.getGroupValues().get(2);
            int port = Integer.parseInt(match.getGroupValues().get(3));
            triple = new Triple<String, Integer, String>(hostName, port, protocol);
        } else {
            this.getLogger().warn("Could not parse MQTT host format: " + host + ", using defaults");
            triple = new Triple<String, Integer, String>(host, 1883, "tcp");
        }
        return triple;
    }

    private final void writeNewConfig(File configFile, Config config2) {
        String content2 = StringsKt.trimMargin$default("\n            |# Configuration version: " + config2.getVersion() + "\n            |version = " + config2.getVersion() + "\n            |agent = {sendTelemetryMs=" + config2.getAgent().getSendTelemetryMs() + ", downloadPath=\"" + config2.getAgent().getDownloadPath() + "\", logLevel=\"" + config2.getAgent().getLogLevel() + "\"}\n            |mqtt = {clientId=\"${random.uuid}\", port=" + config2.getMqtt().getPort() + ", protocol=\"" + config2.getMqtt().getProtocol() + "\"" + (String)(config2.getMqtt().getUsername() != null ? ", username=\"" + config2.getMqtt().getUsername() + "\"" : "") + (String)(config2.getMqtt().getPassword() != null ? ", password=\"" + config2.getMqtt().getPassword() + "\"" : "") + "}\n            |files = {protocol=\"" + config2.getFiles().getProtocol() + "\", port=" + config2.getFiles().getPort() + ", downloadTimeoutMs=" + config2.getFiles().getDownloadTimeoutMs() + "}\n            |service = {tlsEnabled=" + config2.getService().getTlsEnabled() + ", host=\"" + config2.getService().getHost() + "\", port=" + config2.getService().getPort() + "}\n            |edge = {host=\"" + config2.getEdge().getHost() + "\"}\n        ", null, 1, null);
        FilesKt.writeText$default(configFile, content2, null, 2, null);
    }

    private final createLogLevelDecoder.1 createLogLevelDecoder() {
        return new NonNullableLeafDecoder<Level>(){

            @NotNull
            public Validated<ConfigFailure, Level> safeLeafDecode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                Object object;
                Intrinsics.checkNotNullParameter(node2, "node");
                Intrinsics.checkNotNullParameter(type2, "type");
                Intrinsics.checkNotNullParameter(context, "context");
                if (node2 instanceof StringNode) {
                    Level level = Level.getLevel(((StringNode)node2).getValue());
                    object = level;
                    if (object == null || (object = ValidatedKt.valid(object)) == null) {
                        object = ValidatedKt.invalid(new ConfigFailure.DecodeError(node2, type2));
                    }
                } else {
                    object = ValidatedKt.invalid(new ConfigFailure.DecodeError(node2, type2));
                }
                return object;
            }

            public boolean supports(@NotNull KType type2) {
                Intrinsics.checkNotNullParameter(type2, "type");
                return Intrinsics.areEqual(type2.getClassifier(), Reflection.getOrCreateKotlinClass(Level.class));
            }

            @NotNull
            public Validated<ConfigFailure, Level> decode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                return NonNullableLeafDecoder.DefaultImpls.decode(this, node2, type2, context);
            }

            public int priority() {
                return NonNullableLeafDecoder.DefaultImpls.priority(this);
            }

            @NotNull
            public Validated<ConfigFailure, Level> safeDecode(@NotNull Node node2, @NotNull KType type2, @NotNull DecoderContext context) {
                return NonNullableLeafDecoder.DefaultImpls.safeDecode(this, node2, type2, context);
            }
        };
    }

    @NotNull
    public final Config getConfig() {
        Lazy lazy = config$delegate;
        return (Config)lazy.getValue();
    }

    @Override
    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger(this);
    }

    public static final /* synthetic */ createLogLevelDecoder.1 access$createLogLevelDecoder(ConfigHelper $this) {
        return $this.createLogLevelDecoder();
    }

    public static final /* synthetic */ Config access$migrateConfig(ConfigHelper $this, File configFile) {
        return $this.migrateConfig(configFile);
    }

    static {
        File configFile = new File(CONFIG_FILE_NAME);
        if (!configFile.exists()) {
            boolean writable = configFile.setWritable(true, false);
            if (!writable) {
                INSTANCE.getLogger().warn("Configuration file not writable without admin rights ");
            }
            FileUtilsKt.copyFileFromResource(CONFIG_FILE_NAME, configFile);
            String string = configFile.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "configFile.path");
            FileUtilsKt.setWritePermission(string);
        }
        if (!new File("./certs").exists()) {
            Files.createDirectory(Paths.get("./certs", new String[0]), new FileAttribute[0]);
        }
        config$delegate = LazyKt.lazy(config.2.INSTANCE);
    }
}

