/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.utils;

import com.datalogic.agent.config.ConfigHelper;
import com.datalogic.agent.utils.OS;
import com.datalogic.agent.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"copyFileFromResource", "", "resourceFilePath", "", "destination", "Ljava/io/File;", "setWritePermission", "filePath", "dl-client-sdk"})
public final class FileUtilsKt {
    public static final void copyFileFromResource(@NotNull String resourceFilePath, @NotNull File destination) {
        block0: {
            InputStream fileContent;
            Intrinsics.checkNotNullParameter(resourceFilePath, "resourceFilePath");
            Intrinsics.checkNotNullParameter(destination, "destination");
            URL uRL = ConfigHelper.class.getResource("/" + resourceFilePath);
            InputStream inputStream2 = fileContent = uRL != null ? uRL.openStream() : null;
            if (inputStream2 == null) break block0;
            ByteStreamsKt.copyTo$default(inputStream2, new FileOutputStream(destination), 0, 2, null);
        }
    }

    public static final void setWritePermission(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        if (Utils.INSTANCE.getOS() == OS.WINDOWS) {
            Path path = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(...)");
            GroupPrincipal groupPrincipal = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName("Users");
            Intrinsics.checkNotNullExpressionValue(groupPrincipal, "Path(filePath).getFileSy\u2026cipalByGroupName(\"Users\")");
            UserPrincipal user = groupPrincipal;
            Path path2 = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            AclFileAttributeView view = Files.getFileAttributeView(path2, AclFileAttributeView.class, new LinkOption[0]);
            AclEntryPermission[] aclEntryPermissionArray = new AclEntryPermission[]{AclEntryPermission.READ_DATA, AclEntryPermission.EXECUTE, AclEntryPermission.WRITE_DATA, AclEntryPermission.DELETE, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_OWNER, AclEntryPermission.DELETE_CHILD, AclEntryPermission.APPEND_DATA};
            AclEntry entry = AclEntry.newBuilder().setPrincipal(user).setType(AclEntryType.ALLOW).setPermissions(SetsKt.mutableSetOf(aclEntryPermissionArray)).build();
            List<AclEntry> acl = view.getAcl();
            acl.add(0, entry);
            Path path3 = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
            Files.setAttribute(path3, "acl:acl", acl, new LinkOption[0]);
        }
    }
}

