/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.agent.utils;

import com.datalogic.agent.config.ConfigHelper;
import com.datalogic.agent.model.common.CommandStatusCode;
import com.datalogic.agent.model.edge.messages.DeviceCommandResponse;
import com.datalogic.agent.model.service.messages.Device;
import com.datalogic.agent.utils.ConstKt;
import com.datalogic.agent.utils.OS;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ktor.http.URLProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J^\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001a0\u001a2\u001e\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001c0\u001c2\u001e\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001c0\u001c\u00a8\u0006\u001e"}, d2={"Lcom/datalogic/agent/utils/Utils;", "", "()V", "buildCommandResponseAsString", "", "code", "", "message", "content", "commandId", "commandStatusCode", "Lcom/datalogic/agent/model/common/CommandStatusCode;", "getCommandFromTopic", "topic", "getCommandTopicFromDeviceId", "deviceId", "getDeviceFromTopic", "getDeviceListIds", "", "deviceList", "Lcom/datalogic/agent/model/service/messages/Device;", "getOS", "Lcom/datalogic/agent/utils/OS;", "getWebSocketProtocol", "Lio/ktor/http/URLProtocol;", "mergeMaps", "", "first", "", "second", "dl-client-sdk"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/datalogic/agent/utils/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1#2:87\n56#3:88\n43#3:89\n215#4,2:90\n215#4,2:92\n1855#5,2:94\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/datalogic/agent/utils/Utils\n*L\n26#1:88\n26#1:89\n37#1:90,2\n43#1:92,2\n58#1:94,2\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final String getDeviceFromTopic(@NotNull String topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        char[] cArray = new char[]{'/'};
        List topicSplit = StringsKt.split$default((CharSequence)topic, cArray, false, 0, 6, null);
        return (String)topicSplit.get(1);
    }

    @NotNull
    public final String getCommandFromTopic(@NotNull String topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        char[] cArray = new char[]{'/'};
        List topicSplit = StringsKt.split$default((CharSequence)topic, cArray, false, 0, 6, null);
        return (String)CollectionsKt.last(topicSplit);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildCommandResponseAsString(int code, @Nullable String message, @Nullable Object content2, @NotNull String commandId, @NotNull CommandStatusCode commandStatusCode) {
        Object v5;
        Intrinsics.checkNotNullParameter(commandId, "commandId");
        Intrinsics.checkNotNullParameter((Object)commandStatusCode, "commandStatusCode");
        ObjectMapper objectMapper = ConstKt.getObjectMapper();
        int n = code;
        String string = message;
        Object object = content2;
        if (object != null) {
            void it;
            Object object2 = object;
            String string2 = string;
            int n2 = n;
            ObjectMapper objectMapper2 = objectMapper;
            boolean bl = false;
            ObjectMapper objectMapper3 = ConstKt.getObjectMapper();
            Intrinsics.checkNotNullExpressionValue(objectMapper3, "objectMapper");
            ObjectMapper $this$convertValue$iv = objectMapper3;
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            Object t2 = $this$convertValue$iv.convertValue((Object)it, new TypeReference<Object>(){});
            objectMapper = objectMapper2;
            n = n2;
            string = string2;
            v5 = t2;
        } else {
            v5 = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 32;
        List list = null;
        String string3 = commandStatusCode.toString();
        String string4 = commandId;
        Object var20_20 = v5;
        String string5 = string;
        int n4 = n;
        String string6 = objectMapper.writeValueAsString(new DeviceCommandResponse(n4, string5, var20_20, string4, string3, list, n3, defaultConstructorMarker));
        Intrinsics.checkNotNullExpressionValue(string6, "objectMapper.writeValueA\u2026)\n            )\n        )");
        return string6;
    }

    @NotNull
    public final String getCommandTopicFromDeviceId(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter(deviceId, "deviceId");
        String string = "device/%s/command/+";
        Object[] objectArray = new Object[]{deviceId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final Map<String, Map<String, Object>> mergeMaps(@NotNull Map<String, ? extends Map<String, ? extends Object>> first2, @NotNull Map<String, ? extends Map<String, ? extends Object>> second2) {
        Map<String, ? extends Object> value2;
        String key2;
        Map.Entry<String, ? extends Map<String, ? extends Object>> entry;
        Map.Entry<String, ? extends Map<String, ? extends Object>> element$iv;
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        Map resultMap = new LinkedHashMap();
        Map<String, ? extends Map<String, ? extends Object>> $this$forEach$iv = second2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Map<String, ? extends Object>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (!resultMap.containsKey(key2)) {
                resultMap.put(key2, (Map)new LinkedHashMap());
            }
            Map map2 = (Map)resultMap.get(key2);
            if (map2 == null) continue;
            map2.putAll(value2);
        }
        $this$forEach$iv = first2;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (!resultMap.containsKey(key2)) {
                resultMap.put(key2, (Map)new LinkedHashMap());
            }
            Map map3 = (Map)resultMap.get(key2);
            if (map3 == null) continue;
            map3.putAll(value2);
        }
        return resultMap;
    }

    @NotNull
    public final List<String> getDeviceListIds(@NotNull List<Device> deviceList2) {
        Intrinsics.checkNotNullParameter(deviceList2, "deviceList");
        List res = new ArrayList();
        Iterable $this$forEach$iv = deviceList2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Device device = (Device)element$iv;
            boolean bl = false;
            res.add(device.getId());
            res.addAll((Collection)INSTANCE.getDeviceListIds(device.getChildren()));
        }
        return res;
    }

    @NotNull
    public final URLProtocol getWebSocketProtocol() {
        return ConfigHelper.INSTANCE.getConfig().getService().getTlsEnabled() ? URLProtocol.Companion.getWSS() : URLProtocol.Companion.getWS();
    }

    @NotNull
    public final OS getOS() {
        String os = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(os, "os");
        return StringsKt.contains((CharSequence)os, "Windows", true) ? OS.WINDOWS : (StringsKt.contains((CharSequence)os, "linux", true) ? OS.LINUX : OS.UNKNOWN);
    }
}

