/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.decoder;

import com.sksamuel.hoplite.decoder.InformationUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/sksamuel/hoplite/decoder/SizeInBytes;", "", "size", "", "(J)V", "getSize", "()J", "bytes", "component1", "convert", "unit", "Lcom/sksamuel/hoplite/decoder/InformationUnit;", "copy", "equals", "", "other", "gibibytes", "gigabytes", "hashCode", "", "kibibytes", "kilobytes", "mebibytes", "megabytes", "octets", "toString", "", "Companion", "hoplite-core"})
public final class SizeInBytes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long size;

    public SizeInBytes(long size) {
        this.size = size;
    }

    public final long getSize() {
        return this.size;
    }

    public final long bytes() {
        return this.size;
    }

    public final long octets() {
        return this.convert(InformationUnit.Octets.INSTANCE);
    }

    public final long kilobytes() {
        return this.convert(InformationUnit.Kilobytes.INSTANCE);
    }

    public final long kibibytes() {
        return this.convert(InformationUnit.Kibibytes.INSTANCE);
    }

    public final long megabytes() {
        return this.convert(InformationUnit.Megabytes.INSTANCE);
    }

    public final long mebibytes() {
        return this.convert(InformationUnit.Mebibytes.INSTANCE);
    }

    public final long gigabytes() {
        return this.convert(InformationUnit.Gigabytes.INSTANCE);
    }

    public final long gibibytes() {
        return this.convert(InformationUnit.Gibibytes.INSTANCE);
    }

    public final long convert(@NotNull InformationUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return (long)((double)this.size / unit.getRatioToPrimary());
    }

    public final long component1() {
        return this.size;
    }

    @NotNull
    public final SizeInBytes copy(long size) {
        return new SizeInBytes(size);
    }

    public static /* synthetic */ SizeInBytes copy$default(SizeInBytes sizeInBytes, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = sizeInBytes.size;
        }
        return sizeInBytes.copy(l);
    }

    @NotNull
    public String toString() {
        return "SizeInBytes(size=" + this.size + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.size);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SizeInBytes)) {
            return false;
        }
        SizeInBytes sizeInBytes = (SizeInBytes)other;
        return this.size == sizeInBytes.size;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sksamuel/hoplite/decoder/SizeInBytes$Companion;", "", "()V", "parse", "Lcom/sksamuel/hoplite/decoder/SizeInBytes;", "input", "", "hoplite-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SizeInBytes parse(@NotNull String input) {
            Object v1;
            String size;
            block4: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(input, "input");
                Object object = new Regex("(\\d+)(.*?)").matchEntire(((Object)StringsKt.trim((CharSequence)input)).toString());
                if (object == null || (object = object.getDestructured()) == null) {
                    return null;
                }
                Object object2 = object;
                size = ((MatchResult.Destructured)object2).getMatch().getGroupValues().get(1);
                String symbol = ((MatchResult.Destructured)object2).getMatch().getGroupValues().get(2);
                Iterable iterable = Reflection.getOrCreateKotlinClass(InformationUnit.class).getSealedSubclasses();
                boolean $i$f$mapNotNull = false;
                Iterator iterator2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    InformationUnit it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl = false;
                    KClass it = (KClass)element$iv$iv;
                    boolean bl2 = false;
                    if ((InformationUnit)it.getObjectInstance() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                for (Object t2 : iterable2) {
                    InformationUnit it = (InformationUnit)t2;
                    boolean bl = false;
                    if (!StringsKt.equals(it.getSymbol(), ((Object)StringsKt.trim((CharSequence)symbol)).toString(), true)) continue;
                    v1 = t2;
                    break block4;
                }
                v1 = null;
            }
            InformationUnit informationUnit = v1;
            if (informationUnit == null) {
                return null;
            }
            InformationUnit unit = informationUnit;
            double bytes = unit.getRatioToPrimary() * (double)Long.parseLong(size);
            return new SizeInBytes((long)bytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

