/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.internal;

import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.DecoderContext;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.preprocessor.Preprocessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\b\u0012\u0004\u0012\u00020\u000b`\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sksamuel/hoplite/internal/Preprocessing;", "", "preprocessors", "", "Lcom/sksamuel/hoplite/preprocessor/Preprocessor;", "iterations", "", "(Ljava/util/List;I)V", "iterate", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Lcom/sksamuel/hoplite/Node;", "node", "context", "Lcom/sksamuel/hoplite/DecoderContext;", "preprocess", "Lcom/sksamuel/hoplite/ConfigResult;", "process", "hoplite-core"})
public final class Preprocessing {
    @NotNull
    private final List<Preprocessor> preprocessors;
    private final int iterations;

    public Preprocessing(@NotNull List<? extends Preprocessor> preprocessors, int iterations) {
        Intrinsics.checkNotNullParameter(preprocessors, "preprocessors");
        this.preprocessors = preprocessors;
        this.iterations = iterations;
    }

    @NotNull
    public final Validated<ConfigFailure, Node> preprocess(@NotNull Node node2, @NotNull DecoderContext context) {
        Intrinsics.checkNotNullParameter(node2, "node");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.iterate(node2, this.iterations, context);
    }

    private final Validated<ConfigFailure, Node> iterate(Node node2, int iterations, DecoderContext context) {
        Validated<ConfigFailure, Node> validated;
        if (iterations == 0) {
            validated = ValidatedKt.valid(node2);
        } else {
            Validated<ConfigFailure, Node> $this$flatMap$iv = this.process(node2, context);
            boolean $i$f$flatMap = false;
            Validated<ConfigFailure, Node> validated2 = $this$flatMap$iv;
            if (validated2 instanceof Validated.Invalid) {
                validated = $this$flatMap$iv;
            } else if (validated2 instanceof Validated.Valid) {
                Node it = (Node)((Validated.Valid)$this$flatMap$iv).getValue();
                boolean bl = false;
                validated = this.iterate(it, iterations - 1, context);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return validated;
    }

    /*
     * WARNING - void declaration
     */
    private final Validated<ConfigFailure, Node> process(Node node2, DecoderContext context) {
        void $this$fold$iv;
        Iterable iterable = this.preprocessors;
        Validated<ConfigFailure, Node> initial$iv = ValidatedKt.valid(node2);
        boolean $i$f$fold = false;
        Validated<ConfigFailure, Node> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Validated<ConfigFailure, Node> validated;
            Preprocessor preprocessor = (Preprocessor)element$iv;
            Validated<ConfigFailure, Node> acc = accumulator$iv;
            boolean bl = false;
            Validated<ConfigFailure, Node> $this$flatMap$iv = acc;
            boolean $i$f$flatMap = false;
            Validated<ConfigFailure, Node> validated2 = $this$flatMap$iv;
            if (validated2 instanceof Validated.Invalid) {
                validated = $this$flatMap$iv;
            } else if (validated2 instanceof Validated.Valid) {
                void preprocessor2;
                Node it = (Node)((Validated.Valid)$this$flatMap$iv).getValue();
                boolean bl2 = false;
                validated = preprocessor2.process(it, context);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            accumulator$iv = validated;
        }
        return accumulator$iv;
    }
}

