/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.sources;

import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.PropertySource;
import com.sksamuel.hoplite.PropertySourceContext;
import com.sksamuel.hoplite.Undefined;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.parsers.Parser;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/sksamuel/hoplite/sources/UserSettingsPropertySource;", "Lcom/sksamuel/hoplite/PropertySource;", "()V", "node", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Lcom/sksamuel/hoplite/Node;", "Lcom/sksamuel/hoplite/ConfigResult;", "context", "Lcom/sksamuel/hoplite/PropertySourceContext;", "path", "Ljava/nio/file/Path;", "ext", "", "source", "hoplite-core"})
public final class UserSettingsPropertySource
implements PropertySource {
    @NotNull
    public static final UserSettingsPropertySource INSTANCE = new UserSettingsPropertySource();

    private UserSettingsPropertySource() {
    }

    @Override
    @NotNull
    public String source() {
        return System.getProperty("user.home") + "/.userconfig.<ext>";
    }

    private final Path path(String ext) {
        Path path = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".userconfig." + ext);
        Intrinsics.checkNotNullExpressionValue(path, "get(System.getProperty(\"\u2026solve(\".userconfig.$ext\")");
        return path;
    }

    @Override
    @NotNull
    public Validated<ConfigFailure, Node> node(@NotNull PropertySourceContext context) {
        Validated validated;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter(context, "context");
            Iterable $this$firstOrNull$iv = context.getParsers().registeredExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(INSTANCE.path(it), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        String ext = v1;
        if (ext == null) {
            validated = ValidatedKt.valid(Undefined.INSTANCE);
        } else {
            Path path = this.path(ext);
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(this, *options)");
            InputStream input = inputStream2;
            validated = context.getParsers().locate(ext).map((Function1)new Function1<Parser, Node>(input, path){
                final /* synthetic */ InputStream $input;
                final /* synthetic */ Path $path;
                {
                    this.$input = $input;
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Node invoke(@NotNull Parser it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.load(this.$input, ((Object)this.$path).toString());
                }
            });
        }
        return validated;
    }
}

