/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.toml;

import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.MapNode;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.Pos;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.decoder.DotPath;
import com.sksamuel.hoplite.toml.ListProduction;
import com.sksamuel.hoplite.toml.TomlParserKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tomlj.TomlArray;
import org.tomlj.TomlTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002\u00a8\u0006\r"}, d2={"Lcom/sksamuel/hoplite/toml/TableProduction;", "", "()V", "invoke", "Lcom/sksamuel/hoplite/Node;", "table", "Lorg/tomlj/TomlTable;", "pos", "Lcom/sksamuel/hoplite/Pos;", "source", "", "path", "Lcom/sksamuel/hoplite/decoder/DotPath;", "hoplite-toml"})
public final class TableProduction {
    @NotNull
    public static final TableProduction INSTANCE = new TableProduction();

    private TableProduction() {
    }

    @NotNull
    public final Node invoke(@NotNull TomlTable table, @NotNull Pos pos, @NotNull String source2, @NotNull DotPath path) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(path, "path");
        Map obj = new LinkedHashMap();
        for (String key2 : table.keySet()) {
            Node node2;
            Intrinsics.checkNotNullExpressionValue(key2, "key");
            Pos fieldPos = TomlParserKt.toPos(table, key2, source2);
            List<String> keyPath = CollectionsKt.listOf(key2);
            if (table.isBoolean(keyPath)) {
                Boolean bl = table.getBoolean(keyPath);
                Intrinsics.checkNotNull(bl);
                node2 = new BooleanNode(bl, fieldPos, path.with(key2), MapsKt.emptyMap());
            } else if (table.isDouble(keyPath)) {
                Double d = table.getDouble(keyPath);
                Intrinsics.checkNotNull(d);
                node2 = new DoubleNode(d, fieldPos, path.with(key2), MapsKt.emptyMap());
            } else if (table.isLong(keyPath)) {
                Long l = table.getLong(keyPath);
                Intrinsics.checkNotNull(l);
                node2 = new LongNode(l, fieldPos, path.with(key2), MapsKt.emptyMap());
            } else if (table.isString(keyPath)) {
                String string = table.getString(keyPath);
                Intrinsics.checkNotNull(string);
                node2 = new StringNode(string, fieldPos, path.with(key2), MapsKt.emptyMap());
            } else if (table.isArray(keyPath)) {
                TomlArray tomlArray = table.getArray(keyPath);
                Intrinsics.checkNotNull(tomlArray);
                node2 = ListProduction.INSTANCE.invoke(tomlArray, fieldPos, source2, path.with(key2));
            } else if (table.isTable(keyPath)) {
                TomlTable tomlTable = table.getTable(keyPath);
                Intrinsics.checkNotNull(tomlTable);
                node2 = INSTANCE.invoke(tomlTable, fieldPos, source2, path.with(key2));
            } else {
                node2 = new StringNode(String.valueOf(table.get(keyPath)), fieldPos, path.with(key2), MapsKt.emptyMap());
            }
            Node value2 = node2;
            obj.put(key2, value2);
        }
        return new MapNode(obj, pos, path, null, null, 24, null);
    }
}

