/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.cookies;

import io.ktor.client.plugins.cookies.CookiesStorage;
import io.ktor.http.Cookie;
import io.ktor.http.IpParserKt;
import io.ktor.http.URLProtocolKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.util.TextKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a%\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0014\u0010\b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"addCookie", "", "Lio/ktor/client/plugins/cookies/CookiesStorage;", "urlString", "", "cookie", "Lio/ktor/http/Cookie;", "(Lio/ktor/client/plugins/cookies/CookiesStorage;Ljava/lang/String;Lio/ktor/http/Cookie;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fillDefaults", "requestUrl", "Lio/ktor/http/Url;", "matches", "", "ktor-client-core"})
public final class CookiesStorageKt {
    @Nullable
    public static final Object addCookie(@NotNull CookiesStorage $this$addCookie, @NotNull String urlString, @NotNull Cookie cookie, @NotNull Continuation<? super Unit> $completion) {
        Object object = $this$addCookie.addCookie(URLUtilsKt.Url(urlString), cookie, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final boolean matches(@NotNull Cookie $this$matches, @NotNull Url requestUrl) {
        char[] cArray;
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(requestUrl, "requestUrl");
        String string = $this$matches.getDomain();
        if (string == null || (string = TextKt.toLowerCasePreservingASCIIRules(string)) == null || (string = StringsKt.trimStart(string, cArray = new char[]{'.'})) == null) {
            throw new IllegalStateException("Domain field should have the default value".toString());
        }
        String domain = string;
        String $this$matches_u24lambda_u240 = $this$matches.getPath();
        boolean bl = false;
        String string2 = $this$matches.getPath();
        if (string2 == null) {
            throw new IllegalStateException("Path field should have the default value".toString());
        }
        String current = string2;
        String path = StringsKt.endsWith$default((CharSequence)current, '/', false, 2, null) ? current : $this$matches.getPath() + '/';
        String host = TextKt.toLowerCasePreservingASCIIRules(requestUrl.getHost());
        Cookie it = $this$matches;
        boolean bl2 = false;
        String pathInRequest = requestUrl.getEncodedPath();
        String requestPath = StringsKt.endsWith$default((CharSequence)pathInRequest, '/', false, 2, null) ? pathInRequest : pathInRequest + '/';
        if (!(Intrinsics.areEqual(host, domain) || !IpParserKt.hostIsIp(host) && StringsKt.endsWith$default(host, '.' + domain, false, 2, null))) {
            return false;
        }
        if (!(Intrinsics.areEqual(path, "/") || Intrinsics.areEqual(requestPath, path) || StringsKt.startsWith$default(requestPath, path, false, 2, null))) {
            return false;
        }
        return !$this$matches.getSecure() || URLProtocolKt.isSecure(requestUrl.getProtocol());
    }

    @NotNull
    public static final Cookie fillDefaults(@NotNull Cookie $this$fillDefaults, @NotNull Url requestUrl) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter($this$fillDefaults, "<this>");
        Intrinsics.checkNotNullParameter(requestUrl, "requestUrl");
        Cookie result2 = $this$fillDefaults;
        String string = result2.getPath();
        if (!(string != null ? StringsKt.startsWith$default(string, "/", false, 2, null) : false)) {
            result2 = Cookie.copy$default(result2, null, null, null, 0, null, null, requestUrl.getEncodedPath(), false, false, null, 959, null);
        }
        if ((charSequence = (CharSequence)result2.getDomain()) == null || StringsKt.isBlank(charSequence)) {
            result2 = Cookie.copy$default(result2, null, null, null, 0, null, requestUrl.getHost(), null, false, false, null, 991, null);
        }
        return result2;
    }
}

