/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.AttributeKey;
import io.ktor.websocket.Frame;
import io.ktor.websocket.WebSocketDeflateExtension;
import io.ktor.websocket.WebSocketDeflateExtensionKt;
import io.ktor.websocket.WebSocketExtension;
import io.ktor.websocket.WebSocketExtensionFactory;
import io.ktor.websocket.WebSocketExtensionHeader;
import io.ktor.websocket.internals.DeflaterUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension;", "Lio/ktor/websocket/WebSocketExtension;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "config", "(Lio/ktor/websocket/WebSocketDeflateExtension$Config;)V", "decompressIncoming", "", "deflater", "Ljava/util/zip/Deflater;", "factory", "Lio/ktor/websocket/WebSocketExtensionFactory;", "getFactory", "()Lio/ktor/websocket/WebSocketExtensionFactory;", "incomingNoContextTakeover", "getIncomingNoContextTakeover$ktor_websockets", "()Z", "setIncomingNoContextTakeover$ktor_websockets", "(Z)V", "inflater", "Ljava/util/zip/Inflater;", "outgoingNoContextTakeover", "getOutgoingNoContextTakeover$ktor_websockets", "setOutgoingNoContextTakeover$ktor_websockets", "protocols", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "getProtocols", "()Ljava/util/List;", "clientNegotiation", "negotiatedProtocols", "processIncomingFrame", "Lio/ktor/websocket/Frame;", "frame", "processOutgoingFrame", "serverNegotiation", "requestedProtocols", "Companion", "Config", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nWebSocketDeflateExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketDeflateExtension.kt\nio/ktor/websocket/WebSocketDeflateExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public final class WebSocketDeflateExtension
implements WebSocketExtension<Config> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> factory;
    @NotNull
    private final List<WebSocketExtensionHeader> protocols;
    @NotNull
    private final Inflater inflater;
    @NotNull
    private final Deflater deflater;
    private boolean outgoingNoContextTakeover;
    private boolean incomingNoContextTakeover;
    private boolean decompressIncoming;
    @NotNull
    private static final AttributeKey<WebSocketDeflateExtension> key = new AttributeKey("WebsocketDeflateExtension");
    private static final boolean rsv1 = true;
    private static final boolean rsv2;
    private static final boolean rsv3;

    public WebSocketDeflateExtension(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        this.config = config2;
        this.factory = Companion;
        this.protocols = this.config.build$ktor_websockets();
        this.inflater = new Inflater(true);
        this.deflater = new Deflater(this.config.getCompressionLevel(), true);
    }

    @Override
    @NotNull
    public WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public List<WebSocketExtensionHeader> getProtocols() {
        return this.protocols;
    }

    public final boolean getOutgoingNoContextTakeover$ktor_websockets() {
        return this.outgoingNoContextTakeover;
    }

    public final void setOutgoingNoContextTakeover$ktor_websockets(boolean bl) {
        this.outgoingNoContextTakeover = bl;
    }

    public final boolean getIncomingNoContextTakeover$ktor_websockets() {
        return this.incomingNoContextTakeover;
    }

    public final void setIncomingNoContextTakeover$ktor_websockets(boolean bl) {
        this.incomingNoContextTakeover = bl;
    }

    @Override
    public boolean clientNegotiation(@NotNull List<WebSocketExtensionHeader> negotiatedProtocols) {
        Object v0;
        block21: {
            Intrinsics.checkNotNullParameter(negotiatedProtocols, "negotiatedProtocols");
            Iterable iterable = negotiatedProtocols;
            for (Object object : iterable) {
                WebSocketExtensionHeader it = (WebSocketExtensionHeader)object;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "permessage-deflate")) continue;
                v0 = object;
                break block21;
            }
            v0 = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = v0;
        if (webSocketExtensionHeader == null) {
            return false;
        }
        WebSocketExtensionHeader protocol = webSocketExtensionHeader;
        this.incomingNoContextTakeover = this.config.getServerNoContextTakeOver();
        this.outgoingNoContextTakeover = this.config.getClientNoContextTakeOver();
        Iterator<Pair<String, String>> iterator2 = protocol.parseParameters().iterator();
        while (iterator2.hasNext()) {
            Pair<String, String> pair = iterator2.next();
            String key2 = pair.component1();
            String value2 = pair.component2();
            switch (key2) {
                case "server_max_window_bits": {
                    break;
                }
                case "client_max_window_bits": {
                    if (StringsKt.isBlank(value2) || Integer.parseInt(value2) == 15) break;
                    boolean $i$a$-check-WebSocketDeflateExtension$clientNegotiation$42 = false;
                    String $i$a$-check-WebSocketDeflateExtension$clientNegotiation$42 = "Only 15 window size is supported.";
                    throw new IllegalStateException($i$a$-check-WebSocketDeflateExtension$clientNegotiation$42.toString());
                }
                case "server_no_context_takeover": {
                    if (!StringsKt.isBlank(value2)) {
                        boolean $i$a$-check-WebSocketDeflateExtension$clientNegotiation$52 = false;
                        String $i$a$-check-WebSocketDeflateExtension$clientNegotiation$52 = "WebSocket permessage-deflate extension parameter server_no_context_takeover shouldn't have a value. Current: " + value2;
                        throw new IllegalStateException($i$a$-check-WebSocketDeflateExtension$clientNegotiation$52.toString());
                    }
                    this.incomingNoContextTakeover = true;
                    break;
                }
                case "client_no_context_takeover": {
                    if (!StringsKt.isBlank(value2)) {
                        boolean bl = false;
                        String string = "WebSocket permessage-deflate extension parameter client_no_context_takeover shouldn't have a value. Current: " + value2;
                        throw new IllegalStateException(string.toString());
                    }
                    this.outgoingNoContextTakeover = true;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<WebSocketExtensionHeader> serverNegotiation(@NotNull List<WebSocketExtensionHeader> requestedProtocols) {
        Object v0;
        Object object;
        block12: {
            Intrinsics.checkNotNullParameter(requestedProtocols, "requestedProtocols");
            object = requestedProtocols;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                WebSocketExtensionHeader it = (WebSocketExtensionHeader)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "permessage-deflate")) continue;
                v0 = t2;
                break block12;
            }
            v0 = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = v0;
        if (webSocketExtensionHeader == null) {
            return CollectionsKt.emptyList();
        }
        WebSocketExtensionHeader protocol = webSocketExtensionHeader;
        List parameters2 = new ArrayList();
        Iterator<Pair<String, String>> iterator3 = protocol.parseParameters().iterator();
        block7: while (iterator3.hasNext()) {
            String value2;
            String key2;
            block13: {
                String string;
                object = iterator3.next();
                key2 = (String)((Pair)object).component1();
                value2 = (String)((Pair)object).component2();
                String string2 = key2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
                Intrinsics.checkNotNullExpressionValue(string2.toLowerCase(locale), "this as java.lang.String).toLowerCase(locale)");
                switch (string.hashCode()) {
                    case 646404390: {
                        if (string.equals("client_max_window_bits")) continue block7;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + key2 + ", " + value2 + ')').toString());
                    }
                    case -708713803: {
                        if (!string.equals("client_no_context_takeover")) {
                            throw new IllegalStateException(("Unsupported extension parameter: (" + key2 + ", " + value2 + ')').toString());
                        }
                        break block13;
                    }
                    case 1266201133: {
                        if (string.equals("server_no_context_takeover")) break;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + key2 + ", " + value2 + ')').toString());
                    }
                    case 2034279582: {
                        if (!string.equals("server_max_window_bits")) throw new IllegalStateException(("Unsupported extension parameter: (" + key2 + ", " + value2 + ')').toString());
                        if (Integer.parseInt(value2) == 15) continue block7;
                        boolean bl = false;
                        String string3 = "Only 15 window size is supported";
                        throw new IllegalStateException(string3.toString());
                    }
                }
                if (!StringsKt.isBlank(value2)) {
                    String string4 = "Check failed.";
                    throw new IllegalStateException(string4.toString());
                }
                this.outgoingNoContextTakeover = true;
                parameters2.add("server_no_context_takeover");
                continue;
            }
            if (!StringsKt.isBlank(value2)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            this.incomingNoContextTakeover = true;
            parameters2.add("client_no_context_takeover");
            continue;
            throw new IllegalStateException(("Unsupported extension parameter: (" + key2 + ", " + value2 + ')').toString());
        }
        return CollectionsKt.listOf(new WebSocketExtensionHeader("permessage-deflate", parameters2));
    }

    @Override
    @NotNull
    public Frame processOutgoingFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!(frame instanceof Frame.Text) && !(frame instanceof Frame.Binary)) {
            return frame;
        }
        if (!this.config.getCompressCondition$ktor_websockets().invoke(frame).booleanValue()) {
            return frame;
        }
        byte[] deflated2 = DeflaterUtilsKt.deflateFully(this.deflater, frame.getData());
        if (this.outgoingNoContextTakeover) {
            this.deflater.reset();
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), deflated2, rsv1, frame.getRsv2(), frame.getRsv3());
    }

    @Override
    @NotNull
    public Frame processIncomingFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!WebSocketDeflateExtensionKt.access$isCompressed(frame) && !this.decompressIncoming) {
            return frame;
        }
        this.decompressIncoming = true;
        byte[] inflated = DeflaterUtilsKt.inflateFully(this.inflater, frame.getData());
        if (this.incomingNoContextTakeover) {
            this.inflater.reset();
        }
        if (frame.getFin()) {
            this.decompressIncoming = false;
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), inflated, !rsv1, frame.getRsv2(), frame.getRsv3());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0011\u001a\u00020\u00032\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u0015H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Companion;", "Lio/ktor/websocket/WebSocketExtensionFactory;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "Lio/ktor/websocket/WebSocketDeflateExtension;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "rsv1", "", "getRsv1", "()Z", "rsv2", "getRsv2", "rsv3", "getRsv3", "install", "config", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ktor-websockets"})
    public static final class Companion
    implements WebSocketExtensionFactory<Config, WebSocketDeflateExtension> {
        private Companion() {
        }

        @Override
        @NotNull
        public AttributeKey<WebSocketDeflateExtension> getKey() {
            return key;
        }

        @Override
        public boolean getRsv1() {
            return rsv1;
        }

        @Override
        public boolean getRsv2() {
            return rsv2;
        }

        @Override
        public boolean getRsv3() {
            return rsv3;
        }

        @Override
        @NotNull
        public WebSocketDeflateExtension install(@NotNull Function1<? super Config, Unit> config2) {
            Intrinsics.checkNotNullParameter(config2, "config");
            Config config3 = new Config();
            config2.invoke(config3);
            return new WebSocketDeflateExtension(config3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0000\u00a2\u0006\u0002\b!J)\u0010\"\u001a\u00020\u00192!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00040\nJ\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0011J/\u0010)\u001a\u00020\u00192'\u0010#\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00190\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R,\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0004\u0012\u00020\u00190\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\b\u00a8\u0006+"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "", "()V", "clientNoContextTakeOver", "", "getClientNoContextTakeOver", "()Z", "setClientNoContextTakeOver", "(Z)V", "compressCondition", "Lkotlin/Function1;", "Lio/ktor/websocket/Frame;", "getCompressCondition$ktor_websockets", "()Lkotlin/jvm/functions/Function1;", "setCompressCondition$ktor_websockets", "(Lkotlin/jvm/functions/Function1;)V", "compressionLevel", "", "getCompressionLevel", "()I", "setCompressionLevel", "(I)V", "manualConfig", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "", "getManualConfig$ktor_websockets", "setManualConfig$ktor_websockets", "serverNoContextTakeOver", "getServerNoContextTakeOver", "setServerNoContextTakeOver", "build", "", "build$ktor_websockets", "compressIf", "block", "Lkotlin/ParameterName;", "name", "frame", "compressIfBiggerThan", "bytes", "configureProtocols", "protocols", "ktor-websockets"})
    public static final class Config {
        private boolean clientNoContextTakeOver;
        private boolean serverNoContextTakeOver;
        private int compressionLevel = -1;
        @NotNull
        private Function1<? super List<WebSocketExtensionHeader>, Unit> manualConfig = manualConfig.1.INSTANCE;
        @NotNull
        private Function1<? super Frame, Boolean> compressCondition = compressCondition.1.INSTANCE;

        public final boolean getClientNoContextTakeOver() {
            return this.clientNoContextTakeOver;
        }

        public final void setClientNoContextTakeOver(boolean bl) {
            this.clientNoContextTakeOver = bl;
        }

        public final boolean getServerNoContextTakeOver() {
            return this.serverNoContextTakeOver;
        }

        public final void setServerNoContextTakeOver(boolean bl) {
            this.serverNoContextTakeOver = bl;
        }

        public final int getCompressionLevel() {
            return this.compressionLevel;
        }

        public final void setCompressionLevel(int n) {
            this.compressionLevel = n;
        }

        @NotNull
        public final Function1<List<WebSocketExtensionHeader>, Unit> getManualConfig$ktor_websockets() {
            return this.manualConfig;
        }

        public final void setManualConfig$ktor_websockets(@NotNull Function1<? super List<WebSocketExtensionHeader>, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.manualConfig = function1;
        }

        @NotNull
        public final Function1<Frame, Boolean> getCompressCondition$ktor_websockets() {
            return this.compressCondition;
        }

        public final void setCompressCondition$ktor_websockets(@NotNull Function1<? super Frame, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.compressCondition = function1;
        }

        public final void configureProtocols(@NotNull Function1<? super List<WebSocketExtensionHeader>, Unit> block2) {
            Intrinsics.checkNotNullParameter(block2, "block");
            Function1<? super List<WebSocketExtensionHeader>, Unit> old = this.manualConfig;
            this.manualConfig = new Function1<List<WebSocketExtensionHeader>, Unit>(old, block2){
                final /* synthetic */ Function1<List<WebSocketExtensionHeader>, Unit> $old;
                final /* synthetic */ Function1<List<WebSocketExtensionHeader>, Unit> $block;
                {
                    this.$old = $old;
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(@NotNull List<WebSocketExtensionHeader> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$old.invoke(it);
                    this.$block.invoke(it);
                }
            };
        }

        public final void compressIf(@NotNull Function1<? super Frame, Boolean> block2) {
            Intrinsics.checkNotNullParameter(block2, "block");
            Function1<? super Frame, Boolean> old = this.compressCondition;
            this.compressCondition = new Function1<Frame, Boolean>(block2, old){
                final /* synthetic */ Function1<Frame, Boolean> $block;
                final /* synthetic */ Function1<Frame, Boolean> $old;
                {
                    this.$block = $block;
                    this.$old = $old;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Frame it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$block.invoke(it) != false && this.$old.invoke(it) != false;
                }
            };
        }

        public final void compressIfBiggerThan(int bytes) {
            this.compressIf((Function1<? super Frame, Boolean>)new Function1<Frame, Boolean>(bytes){
                final /* synthetic */ int $bytes;
                {
                    this.$bytes = $bytes;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Frame frame) {
                    Intrinsics.checkNotNullParameter(frame, "frame");
                    return frame.getData().length > this.$bytes;
                }
            });
        }

        @NotNull
        public final List<WebSocketExtensionHeader> build$ktor_websockets() {
            List result2 = new ArrayList();
            List parameters2 = new ArrayList();
            if (this.clientNoContextTakeOver) {
                ((Collection)parameters2).add("client_no_context_takeover");
            }
            if (this.serverNoContextTakeOver) {
                ((Collection)parameters2).add("server_no_context_takeover");
            }
            ((Collection)result2).add(new WebSocketExtensionHeader("permessage-deflate", parameters2));
            this.manualConfig.invoke(result2);
            return result2;
        }
    }
}

