/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.baggage.ImmutableEntry;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableBaggage
extends ImmutableKeyValuePairs<String, BaggageEntry>
implements Baggage {
    private static final Baggage EMPTY = new Builder().build();

    private ImmutableBaggage(Object[] data2) {
        super(data2, Comparator.naturalOrder());
    }

    static Baggage empty() {
        return EMPTY;
    }

    static BaggageBuilder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        BaggageEntry entry = (BaggageEntry)this.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        return new Builder(new ArrayList<Object>(this.data()));
    }

    private static Baggage sortAndFilterToBaggage(Object[] data2) {
        return new ImmutableBaggage(data2);
    }

    static class Builder
    implements BaggageBuilder {
        private final List<Object> data;

        Builder() {
            this.data = new ArrayList<Object>();
        }

        Builder(List<Object> data2) {
            this.data = data2;
        }

        @Override
        public BaggageBuilder put(String key2, String value2, BaggageEntryMetadata entryMetadata) {
            if (key2 == null || value2 == null || entryMetadata == null) {
                return this;
            }
            this.data.add(key2);
            this.data.add(ImmutableEntry.create(value2, entryMetadata));
            return this;
        }

        @Override
        public BaggageBuilder remove(String key2) {
            if (key2 == null) {
                return this;
            }
            this.data.add(key2);
            this.data.add(null);
            return this;
        }

        @Override
        public Baggage build() {
            return ImmutableBaggage.sortAndFilterToBaggage(this.data.toArray());
        }
    }
}

