/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.ArrayBackedAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> data2) {
        this.data = data2;
    }

    @Override
    public Attributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedAttributes(this.data.toArray());
        }
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key2, int value2) {
        return this.put((AttributeKey<T>)key2, (T)Long.valueOf(value2));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key2, T value2) {
        if (key2 == null || key2.getKey().isEmpty() || value2 == null) {
            return this;
        }
        this.data.add(key2);
        this.data.add(value2);
        return this;
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes2) {
        if (attributes2 == null) {
            return this;
        }
        attributes2.forEach((key2, value2) -> this.put((AttributeKey<T>)((AttributeKey)key2), (T)value2));
        return this;
    }

    @Override
    public <T> AttributesBuilder remove(AttributeKey<T> key2) {
        if (key2 == null || key2.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(entryKey -> key2.getKey().equals(entryKey.getKey()) && key2.getType().equals((Object)entryKey.getType()));
    }

    @Override
    public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof AttributeKey) || !predicate.test((AttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values2) {
        Double[] boxed = new Double[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values2) {
        Long[] boxed = new Long[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values2) {
        Boolean[] boxed = new Boolean[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }
}

