/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public interface AttributesBuilder {
    public Attributes build();

    public <T> AttributesBuilder put(AttributeKey<Long> var1, int var2);

    public <T> AttributesBuilder put(AttributeKey<T> var1, T var2);

    default public AttributesBuilder put(String key2, String value2) {
        return this.put(AttributeKey.stringKey(key2), (T)value2);
    }

    default public AttributesBuilder put(String key2, long value2) {
        return this.put((AttributeKey<T>)AttributeKey.longKey(key2), (T)value2);
    }

    default public AttributesBuilder put(String key2, double value2) {
        return this.put(AttributeKey.doubleKey(key2), (T)value2);
    }

    default public AttributesBuilder put(String key2, boolean value2) {
        return this.put(AttributeKey.booleanKey(key2), (T)value2);
    }

    default public AttributesBuilder put(String key2, String ... value2) {
        if (value2 == null) {
            return this;
        }
        return this.put(AttributeKey.stringArrayKey(key2), (T)Arrays.asList(value2));
    }

    default public <T> AttributesBuilder put(AttributeKey<List<T>> key2, T ... value2) {
        if (value2 == null) {
            return this;
        }
        return this.put((AttributeKey<T>)key2, (T)Arrays.asList(value2));
    }

    default public AttributesBuilder put(String key2, long ... value2) {
        if (value2 == null) {
            return this;
        }
        return this.put(AttributeKey.longArrayKey(key2), (T)ArrayBackedAttributesBuilder.toList(value2));
    }

    default public AttributesBuilder put(String key2, double ... value2) {
        if (value2 == null) {
            return this;
        }
        return this.put(AttributeKey.doubleArrayKey(key2), (T)ArrayBackedAttributesBuilder.toList(value2));
    }

    default public AttributesBuilder put(String key2, boolean ... value2) {
        if (value2 == null) {
            return this;
        }
        return this.put(AttributeKey.booleanArrayKey(key2), (T)ArrayBackedAttributesBuilder.toList(value2));
    }

    public AttributesBuilder putAll(Attributes var1);

    default public <T> AttributesBuilder remove(AttributeKey<T> key2) {
        return this;
    }

    default public AttributesBuilder removeIf(Predicate<AttributeKey<?>> filter2) {
        return this;
    }
}

