/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.events;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.logs.AnyValue;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public interface EventBuilder {
    default public EventBuilder put(String key2, String value2) {
        return this.put(key2, AnyValue.of(value2));
    }

    default public EventBuilder put(String key2, long value2) {
        return this.put(key2, AnyValue.of(value2));
    }

    default public EventBuilder put(String key2, double value2) {
        return this.put(key2, AnyValue.of(value2));
    }

    default public EventBuilder put(String key2, boolean value2) {
        return this.put(key2, AnyValue.of(value2));
    }

    default public EventBuilder put(String key2, String ... value2) {
        ArrayList values2 = new ArrayList(value2.length);
        for (String val : value2) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key2, AnyValue.of(values2));
    }

    default public EventBuilder put(String key2, long ... value2) {
        ArrayList values2 = new ArrayList(value2.length);
        for (long val : value2) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key2, AnyValue.of(values2));
    }

    default public EventBuilder put(String key2, double ... value2) {
        ArrayList values2 = new ArrayList(value2.length);
        for (double val : value2) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key2, AnyValue.of(values2));
    }

    default public EventBuilder put(String key2, boolean ... value2) {
        ArrayList values2 = new ArrayList(value2.length);
        for (boolean val : value2) {
            values2.add(AnyValue.of(val));
        }
        return this.put(key2, AnyValue.of(values2));
    }

    default public <T> EventBuilder put(AttributeKey<T> key2, T value2) {
        switch (key2.getType()) {
            case STRING: {
                return this.put(key2.getKey(), (String)value2);
            }
            case BOOLEAN: {
                return this.put(key2.getKey(), (boolean)((Boolean)value2));
            }
            case LONG: {
                return this.put(key2.getKey(), (long)((Long)value2));
            }
            case DOUBLE: {
                return this.put(key2.getKey(), (double)((Double)value2));
            }
            case STRING_ARRAY: {
                return this.put(key2.getKey(), AnyValue.of(((List)value2).stream().map(AnyValue::of).collect(Collectors.toList())));
            }
            case BOOLEAN_ARRAY: {
                return this.put(key2.getKey(), AnyValue.of(((List)value2).stream().map(AnyValue::of).collect(Collectors.toList())));
            }
            case LONG_ARRAY: {
                return this.put(key2.getKey(), AnyValue.of(((List)value2).stream().map(AnyValue::of).collect(Collectors.toList())));
            }
            case DOUBLE_ARRAY: {
                return this.put(key2.getKey(), AnyValue.of(((List)value2).stream().map(AnyValue::of).collect(Collectors.toList())));
            }
        }
        return this;
    }

    public EventBuilder put(String var1, AnyValue<?> var2);

    public EventBuilder setTimestamp(long var1, TimeUnit var3);

    public EventBuilder setTimestamp(Instant var1);

    public EventBuilder setContext(Context var1);

    public EventBuilder setSeverity(Severity var1);

    public EventBuilder setAttributes(Attributes var1);

    public void emit();
}

