/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.logs;

import io.opentelemetry.api.incubator.logs.AnyValue;
import io.opentelemetry.api.incubator.logs.AnyValueType;
import io.opentelemetry.api.incubator.logs.KeyAnyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class KeyAnyValueList
implements AnyValue<List<KeyAnyValue>> {
    private final List<KeyAnyValue> value;

    private KeyAnyValueList(List<KeyAnyValue> value2) {
        this.value = value2;
    }

    static AnyValue<List<KeyAnyValue>> create(KeyAnyValue ... value2) {
        Objects.requireNonNull(value2, "value must not be null");
        ArrayList<KeyAnyValue> list = new ArrayList<KeyAnyValue>(value2.length);
        list.addAll(Arrays.asList(value2));
        return new KeyAnyValueList(Collections.unmodifiableList(list));
    }

    static AnyValue<List<KeyAnyValue>> createFromMap(Map<String, AnyValue<?>> value2) {
        Objects.requireNonNull(value2, "value must not be null");
        KeyAnyValue[] array = (KeyAnyValue[])value2.entrySet().stream().map(entry -> KeyAnyValue.of((String)entry.getKey(), (AnyValue)entry.getValue())).toArray(KeyAnyValue[]::new);
        return KeyAnyValueList.create(array);
    }

    @Override
    public AnyValueType getType() {
        return AnyValueType.KEY_VALUE_LIST;
    }

    @Override
    public List<KeyAnyValue> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(item -> item.getKey() + "=" + item.getAnyValue().asString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "KeyAnyValueList{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof AnyValue && Objects.equals(this.value, ((AnyValue)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

