/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class InternalAttributeKeyImpl<T>
implements AttributeKey<T> {
    private final AttributeType type;
    private final String key;
    private final int hashCode;
    @Nullable
    private byte[] keyUtf8;

    private InternalAttributeKeyImpl(AttributeType type2, String key2) {
        if (type2 == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type2;
        if (key2 == null) {
            throw new NullPointerException("Null key");
        }
        this.key = key2;
        this.hashCode = InternalAttributeKeyImpl.buildHashCode(type2, key2);
    }

    public static <T> AttributeKey<T> create(@Nullable String key2, AttributeType type2) {
        return new InternalAttributeKeyImpl<T>(type2, key2 != null ? key2 : "");
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public byte[] getKeyUtf8() {
        byte[] keyUtf8 = this.keyUtf8;
        if (keyUtf8 == null) {
            this.keyUtf8 = keyUtf8 = this.key.getBytes(StandardCharsets.UTF_8);
        }
        return keyUtf8;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalAttributeKeyImpl) {
            InternalAttributeKeyImpl that = (InternalAttributeKeyImpl)o;
            return this.type.equals((Object)that.getType()) && this.key.equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.key;
    }

    private int buildHashCode() {
        return InternalAttributeKeyImpl.buildHashCode(this.type, this.key);
    }

    private static int buildHashCode(AttributeType type2, String key2) {
        int result2 = 1;
        result2 *= 1000003;
        result2 ^= type2.hashCode();
        result2 *= 1000003;
        return result2 ^= key2.hashCode();
    }
}

