/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.exporter.internal.marshal.WireFormat;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CodedOutputStream {
    private static final int DEFAULT_BUFFER_SIZE;
    private static final ThreadLocal<OutputStreamEncoder> THREAD_LOCAL_CODED_OUTPUT_STREAM;

    static CodedOutputStream newInstance(OutputStream output) {
        OutputStreamEncoder cos = THREAD_LOCAL_CODED_OUTPUT_STREAM.get();
        if (cos == null) {
            cos = new OutputStreamEncoder(output);
            THREAD_LOCAL_CODED_OUTPUT_STREAM.set(cos);
        } else {
            cos.reset(output);
        }
        return cos;
    }

    private CodedOutputStream() {
    }

    final void writeRawBytes(byte[] value2) throws IOException {
        this.write(value2, 0, value2.length);
    }

    abstract void writeInt32NoTag(int var1) throws IOException;

    abstract void writeUInt32NoTag(int var1) throws IOException;

    final void writeSInt32NoTag(int value2) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    abstract void writeFixed32NoTag(int var1) throws IOException;

    final void writeSFixed32NoTag(int value2) throws IOException {
        this.writeFixed32NoTag(value2);
    }

    final void writeInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(value2);
    }

    abstract void writeUInt64NoTag(long var1) throws IOException;

    final void writeSInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    abstract void writeFixed64NoTag(long var1) throws IOException;

    final void writeSFixed64NoTag(long value2) throws IOException {
        this.writeFixed64NoTag(value2);
    }

    final void writeFloatNoTag(float value2) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value2));
    }

    final void writeDoubleNoTag(double value2) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value2));
    }

    final void writeBoolNoTag(boolean value2) throws IOException {
        this.write((byte)(value2 ? 1 : 0));
    }

    final void writeEnumNoTag(int value2) throws IOException {
        this.writeInt32NoTag(value2);
    }

    final void writeByteArrayNoTag(byte[] value2) throws IOException {
        this.writeByteArrayNoTag(value2, 0, value2.length);
    }

    abstract void write(byte var1) throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    static int computeInt32SizeNoTag(int value2) {
        if (value2 >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(value2);
        }
        return 10;
    }

    static int computeUInt32SizeNoTag(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int computeSInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    static int computeFixed32SizeNoTag(int unused) {
        return 4;
    }

    static int computeSFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    static int computeUInt64SizeNoTag(long value2) {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value2 < 0L) {
            return 10;
        }
        int n = 2;
        if ((value2 & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value2 >>>= 28;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value2 >>>= 14;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    static int computeSInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    static int computeFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeSFixed64SizeNoTag(long unused) {
        return 8;
    }

    static int computeFloatSizeNoTag(float unused) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double unused) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean unused) {
        return 1;
    }

    static int computeEnumSizeNoTag(int value2) {
        return CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeByteArraySizeNoTag(byte[] value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.length);
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + fieldLength;
    }

    static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    abstract void flush() throws IOException;

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    static {
        int bufferSize = 51200;
        try {
            String bufferSizeConfig = ConfigUtil.getString("otel.experimental.otlp.buffer-size", "");
            if (!bufferSizeConfig.isEmpty()) {
                bufferSize = Integer.parseInt(bufferSizeConfig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_BUFFER_SIZE = bufferSize;
        THREAD_LOCAL_CODED_OUTPUT_STREAM = new ThreadLocal();
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private OutputStream out;

        OutputStreamEncoder(OutputStream out2) {
            super(DEFAULT_BUFFER_SIZE);
            this.out = out2;
        }

        void reset(OutputStream out2) {
            this.out = out2;
            this.position = 0;
            this.totalBytesWritten = 0;
        }

        @Override
        void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        void write(byte value2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(value2);
        }

        @Override
        void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        void writeUInt32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(value2);
        }

        @Override
        void writeFixed32NoTag(int value2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(value2);
        }

        @Override
        void writeUInt64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(value2);
        }

        @Override
        void writeFixed64NoTag(long value2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(value2);
        }

        @Override
        void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        void write(byte[] value2, int offset, int length) throws IOException {
            if (this.limit - this.position >= length) {
                System.arraycopy(value2, offset, this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value2, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value2, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    this.out.write(value2, offset, length);
                }
                this.totalBytesWritten += length;
            }
        }

        private void flushIfNotAvailable(int requiredSize) throws IOException {
            if (this.limit - this.position < requiredSize) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.limit = this.buffer.length;
        }

        final void buffer(byte value2) {
            this.buffer[this.position++] = value2;
            ++this.totalBytesWritten;
        }

        final void bufferUInt32NoTag(int value2) {
            while (true) {
                if ((value2 & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)value2;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value2 >>>= 7;
            }
        }

        final void bufferUInt64NoTag(long value2) {
            while (true) {
                if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)value2;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)value2 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                value2 >>>= 7;
            }
        }

        final void bufferFixed32NoTag(int value2) {
            this.buffer[this.position++] = (byte)(value2 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long value2) {
            this.buffer[this.position++] = (byte)(value2 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(value2 >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(value2 >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }
}

