/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;
import java.nio.ByteBuffer;

final class BytesAnyValueStatelessMarshaler
implements StatelessMarshaler<ByteBuffer> {
    static final BytesAnyValueStatelessMarshaler INSTANCE = new BytesAnyValueStatelessMarshaler();

    private BytesAnyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, ByteBuffer value2, MarshalerContext context) throws IOException {
        byte[] bytes = context.getData(byte[].class);
        output.writeBytes(AnyValue.BYTES_VALUE, bytes);
    }

    @Override
    public int getBinarySerializedSize(ByteBuffer value2, MarshalerContext context) {
        byte[] bytes = new byte[value2.remaining()];
        value2.get(bytes);
        context.addData(bytes);
        return AnyValue.BYTES_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(bytes);
    }
}

