/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;

final class DoubleAnyValueMarshaler
extends MarshalerWithSize {
    private final double value;

    private DoubleAnyValueMarshaler(double value2) {
        super(DoubleAnyValueMarshaler.calculateSize(value2));
        this.value = value2;
    }

    static MarshalerWithSize create(double value2) {
        return new DoubleAnyValueMarshaler(value2);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeDouble(AnyValue.DOUBLE_VALUE, this.value);
    }

    private static int calculateSize(double value2) {
        return AnyValue.DOUBLE_VALUE.getTagSize() + CodedOutputStream.computeDoubleSizeNoTag(value2);
    }
}

