/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;

final class IntAnyValueMarshaler
extends MarshalerWithSize {
    private final long value;

    private IntAnyValueMarshaler(long value2) {
        super(IntAnyValueMarshaler.calculateSize(value2));
        this.value = value2;
    }

    static MarshalerWithSize create(long value2) {
        return new IntAnyValueMarshaler(value2);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeInt64(AnyValue.INT_VALUE, this.value);
    }

    private static int calculateSize(long value2) {
        return AnyValue.INT_VALUE.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(value2);
    }
}

