/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.incubator.logs.KeyAnyValue;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AnyValueStatelessMarshaler;
import io.opentelemetry.proto.common.v1.internal.KeyValue;
import java.io.IOException;

public final class KeyValueStatelessMarshaler
implements StatelessMarshaler<KeyAnyValue> {
    public static final KeyValueStatelessMarshaler INSTANCE = new KeyValueStatelessMarshaler();
    private static final byte[] EMPTY_BYTES = new byte[0];

    private KeyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, KeyAnyValue value2, MarshalerContext context) throws IOException {
        String key2 = value2.getKey();
        if (key2.isEmpty()) {
            output.serializeString(KeyValue.KEY, EMPTY_BYTES);
        } else {
            output.serializeStringWithContext(KeyValue.KEY, key2, context);
        }
        output.serializeMessageWithContext(KeyValue.VALUE, value2.getAnyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
    }

    @Override
    public int getBinarySerializedSize(KeyAnyValue value2, MarshalerContext context) {
        int size = 0;
        String key2 = value2.getKey();
        if (!key2.isEmpty()) {
            size += StatelessMarshalerUtil.sizeStringWithContext(KeyValue.KEY, key2, context);
        }
        return size += StatelessMarshalerUtil.sizeMessageWithContext(KeyValue.VALUE, value2.getAnyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
    }
}

