/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.metrics.v1.internal.SummaryDataPoint;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import java.io.IOException;
import java.util.List;

final class ValueAtQuantileMarshaler
extends MarshalerWithSize {
    private final double quantile;
    private final double value;

    static ValueAtQuantileMarshaler[] createRepeated(List<ValueAtQuantile> values2) {
        int numValues = values2.size();
        ValueAtQuantileMarshaler[] marshalers = new ValueAtQuantileMarshaler[numValues];
        for (int i = 0; i < numValues; ++i) {
            marshalers[i] = ValueAtQuantileMarshaler.create(values2.get(i));
        }
        return marshalers;
    }

    private static ValueAtQuantileMarshaler create(ValueAtQuantile value2) {
        return new ValueAtQuantileMarshaler(value2.getQuantile(), value2.getValue());
    }

    private ValueAtQuantileMarshaler(double quantile, double value2) {
        super(ValueAtQuantileMarshaler.calculateSize(quantile, value2));
        this.quantile = quantile;
        this.value = value2;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeDouble(SummaryDataPoint.ValueAtQuantile.QUANTILE, this.quantile);
        output.serializeDouble(SummaryDataPoint.ValueAtQuantile.VALUE, this.value);
    }

    static int calculateSize(double quantile, double value2) {
        int size = 0;
        size += MarshalerUtil.sizeDouble(SummaryDataPoint.ValueAtQuantile.QUANTILE, quantile);
        return size += MarshalerUtil.sizeDouble(SummaryDataPoint.ValueAtQuantile.VALUE, value2);
    }
}

