/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.exporter.internal.InstrumentationUtil;
import io.opentelemetry.exporter.internal.RetryUtil;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.okhttp.internal.GrpcRequestBody;
import io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttpGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Supplier<Map<String, List<String>>> headersSupplier;
    @Nullable
    private final Compressor compressor;

    public OkHttpGrpcSender(String endpoint, @Nullable Compressor compressor, long timeoutNanos, long connectTimeoutNanos, Supplier<Map<String, List<String>>> headersSupplier, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        boolean isPlainHttp;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(timeoutNanos)).connectTimeout(Duration.ofNanos(connectTimeoutNanos));
        if (retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpGrpcSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            clientBuilder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
            if (sslContext != null && trustManager != null) {
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
        }
        this.client = clientBuilder.build();
        this.headersSupplier = headersSupplier;
        this.url = HttpUrl.get(endpoint);
        this.compressor = compressor;
    }

    @Override
    public void send(T request2, final Runnable onSuccess, final BiConsumer<GrpcResponse, Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headersSupplier.get();
        if (headers != null) {
            headers.forEach((key2, values2) -> values2.forEach(value2 -> requestBuilder.addHeader((String)key2, (String)value2)));
        }
        requestBuilder.addHeader("te", "trailers");
        if (this.compressor != null) {
            requestBuilder.addHeader("grpc-encoding", this.compressor.getEncoding());
        }
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)request2, this.compressor);
        requestBuilder.post(requestBody);
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                String description2 = e.getMessage();
                if (description2 == null) {
                    description2 = "";
                }
                onError.accept(GrpcResponse.create(2, description2), e);
            }

            @Override
            public void onResponse(Call call, Response response2) {
                int statusCode;
                try {
                    response2.body().bytes();
                }
                catch (IOException e) {
                    onError.accept(GrpcResponse.create(2, "Could not consume server response."), e);
                    return;
                }
                String status = OkHttpGrpcSender.grpcStatus(response2);
                if ("0".equals(status)) {
                    onSuccess.run();
                    return;
                }
                String errorMessage2 = OkHttpGrpcSender.grpcMessage(response2);
                try {
                    statusCode = Integer.parseInt(status);
                }
                catch (NumberFormatException ex) {
                    statusCode = 2;
                }
                onError.accept(GrpcResponse.create(statusCode, errorMessage2), new IllegalStateException(errorMessage2));
            }
        }));
    }

    @Nullable
    private static String grpcStatus(Response response2) {
        String grpcStatus = response2.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response2.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response2) {
        String message = response2.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response2.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcSender.unescape(message);
        }
        return response2.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response2) {
        if (!response2.isSuccessful()) {
            return false;
        }
        String grpcStatus = response2.header(GRPC_STATUS);
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value2) {
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value2.length())) continue;
            return OkHttpGrpcSender.doUnescape(value2.getBytes(StandardCharsets.US_ASCII));
        }
        return value2;
    }

    private static String doUnescape(byte[] value2) {
        ByteBuffer buf = ByteBuffer.allocate(value2.length);
        int i = 0;
        while (i < value2.length) {
            if (value2[i] == 37 && i + 2 < value2.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value2, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value2[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

