/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;

final class PropagatorConfiguration {
    private static final List<String> DEFAULT_PROPAGATORS = Arrays.asList("tracecontext", "baggage");

    static ContextPropagators configurePropagators(ConfigProperties config2, SpiHelper spiHelper, BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer) {
        LinkedHashSet<TextMapPropagator> propagators = new LinkedHashSet<TextMapPropagator>();
        List<String> requestedPropagators = config2.getList("otel.propagators", DEFAULT_PROPAGATORS);
        NamedSpiManager<TextMapPropagator> spiPropagatorsManager = spiHelper.loadConfigurable(ConfigurablePropagatorProvider.class, ConfigurablePropagatorProvider::getName, ConfigurablePropagatorProvider::getPropagator, config2);
        if (requestedPropagators.contains("none")) {
            if (requestedPropagators.size() > 1) {
                throw new ConfigurationException("otel.propagators contains 'none' along with other propagators");
            }
            return ContextPropagators.noop();
        }
        for (String propagatorName : requestedPropagators) {
            propagators.add(propagatorCustomizer.apply(PropagatorConfiguration.getPropagator(propagatorName, spiPropagatorsManager), config2));
        }
        return ContextPropagators.create(TextMapPropagator.composite(propagators));
    }

    private static TextMapPropagator getPropagator(String name, NamedSpiManager<TextMapPropagator> spiPropagatorsManager) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        TextMapPropagator spiPropagator = spiPropagatorsManager.getByName(name);
        if (spiPropagator != null) {
            return spiPropagator;
        }
        throw new ConfigurationException("Unrecognized value for otel.propagators: " + name + ". Make sure the artifact including the propagator is on the classpath.");
    }

    private PropagatorConfiguration() {
    }
}

