/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;

public final class ResourceConfiguration {
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey("service.name");
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String DISABLED_ATTRIBUTE_KEYS = "otel.experimental.resource.disabled.keys";

    public static Resource createEnvironmentResource() {
        return ResourceConfiguration.createEnvironmentResource(DefaultConfigProperties.create(Collections.emptyMap()));
    }

    public static Resource createEnvironmentResource(ConfigProperties config2) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        try {
            for (Map.Entry<String, String> entry : config2.getMap(ATTRIBUTE_PROPERTY).entrySet()) {
                resourceAttributes.put(entry.getKey(), URLDecoder.decode(entry.getValue(), StandardCharsets.UTF_8.displayName()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException("Unable to decode resource attributes.", e);
        }
        String serviceName = config2.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(SERVICE_NAME, serviceName);
        }
        return Resource.create(resourceAttributes.build());
    }

    static Resource configureResource(ConfigProperties config2, SpiHelper spiHelper, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Resource result2 = Resource.getDefault();
        HashSet<String> enabledProviders = new HashSet<String>(config2.getList("otel.java.enabled.resource.providers"));
        HashSet<String> disabledProviders = new HashSet<String>(config2.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : spiHelper.loadOrdered(ResourceProvider.class)) {
            if (!enabledProviders.isEmpty() && !enabledProviders.contains(resourceProvider.getClass().getName()) || disabledProviders.contains(resourceProvider.getClass().getName()) || resourceProvider instanceof ConditionalResourceProvider && !((ConditionalResourceProvider)resourceProvider).shouldApply(config2, result2)) continue;
            result2 = result2.merge(resourceProvider.createResource(config2));
        }
        result2 = ResourceConfiguration.filterAttributes(result2, config2);
        return resourceCustomizer.apply(result2, config2);
    }

    static Resource filterAttributes(Resource resource, ConfigProperties configProperties) {
        HashSet<String> disabledKeys = new HashSet<String>(configProperties.getList(DISABLED_ATTRIBUTE_KEYS));
        ResourceBuilder builder = resource.toBuilder().removeIf(attributeKey -> disabledKeys.contains(attributeKey.getKey()));
        if (resource.getSchemaUrl() != null) {
            builder.setSchemaUrl(resource.getSchemaUrl());
        }
        return builder.build();
    }

    private ResourceConfiguration() {
    }
}

