/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.internal;

import io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SpiHelper {
    private final ComponentLoader componentLoader;
    private final Set<AutoConfigureListener> listeners = Collections.newSetFromMap(new IdentityHashMap());

    private SpiHelper(ComponentLoader componentLoader) {
        this.componentLoader = componentLoader;
    }

    public static SpiHelper create(ClassLoader classLoader) {
        return new SpiHelper(new ServiceLoaderComponentLoader(classLoader));
    }

    public static SpiHelper create(ComponentLoader componentLoader) {
        return new SpiHelper(componentLoader);
    }

    public <T, S> NamedSpiManager<T> loadConfigurable(Class<S> spiClass, Function<S, String> getName, BiFunction<S, ConfigProperties, T> getConfigurable, ConfigProperties config2) {
        HashMap nameToProvider = new HashMap();
        for (Object provider2 : this.load(spiClass)) {
            String name = getName.apply(provider2);
            nameToProvider.put(name, () -> {
                Object result2 = getConfigurable.apply(provider2, config2);
                this.maybeAddListener(result2);
                return result2;
            });
        }
        return NamedSpiManager.create(nameToProvider);
    }

    public <T extends Ordered> List<T> loadOrdered(Class<T> spiClass) {
        List<T> result2 = this.load(spiClass);
        result2.sort(Comparator.comparing(Ordered::order));
        return result2;
    }

    public <T> List<T> load(Class<T> spiClass) {
        ArrayList<T> result2 = new ArrayList<T>();
        for (T service : this.componentLoader.load(spiClass)) {
            this.maybeAddListener(service);
            result2.add(service);
        }
        return result2;
    }

    private void maybeAddListener(Object object) {
        if (object instanceof AutoConfigureListener) {
            this.listeners.add((AutoConfigureListener)object);
        }
    }

    public Set<AutoConfigureListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    private static class ServiceLoaderComponentLoader
    implements ComponentLoader {
        private final ClassLoader classLoader;

        private ServiceLoaderComponentLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public <T> Iterable<T> load(Class<T> spiClass) {
            return ServiceLoader.load(spiClass, this.classLoader);
        }
    }
}

