/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static Attributes applyAttributesLimit(Attributes attributes2, int countLimit, int lengthLimit) {
        if (attributes2.isEmpty() || attributes2.size() <= countLimit) {
            if (lengthLimit == Integer.MAX_VALUE) {
                return attributes2;
            }
            boolean allValidLength = AttributeUtil.allMatch(attributes2.asMap().values(), value2 -> AttributeUtil.isValidLength(value2, lengthLimit));
            if (allValidLength) {
                return attributes2;
            }
        }
        AttributesBuilder result2 = Attributes.builder();
        int i = 0;
        for (Map.Entry<AttributeKey<?>, Object> entry : attributes2.asMap().entrySet()) {
            if (i >= countLimit) break;
            result2.put(entry.getKey(), AttributeUtil.applyAttributeLengthLimit(entry.getValue(), lengthLimit));
            ++i;
        }
        return result2.build();
    }

    private static boolean isValidLength(Object value2, int lengthLimit) {
        if (value2 instanceof List) {
            return AttributeUtil.allMatch((List)value2, entry -> AttributeUtil.isValidLength(entry, lengthLimit));
        }
        if (value2 instanceof String) {
            return ((String)value2).length() < lengthLimit;
        }
        return true;
    }

    private static <T> boolean allMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T value2 : iterable) {
            if (predicate.test(value2)) continue;
            return false;
        }
        return true;
    }

    public static Object applyAttributeLengthLimit(Object value2, int lengthLimit) {
        if (lengthLimit == Integer.MAX_VALUE) {
            return value2;
        }
        if (value2 instanceof List) {
            List values2 = (List)value2;
            ArrayList<Object> response2 = new ArrayList<Object>(values2.size());
            for (Object entry : values2) {
                response2.add(AttributeUtil.applyAttributeLengthLimit(entry, lengthLimit));
            }
            return response2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            return str.length() < lengthLimit ? value2 : str.substring(0, lengthLimit);
        }
        return value2;
    }
}

