/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.SdkLogRecordData;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class AutoValue_SdkLogRecordData
extends SdkLogRecordData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long timestampEpochNanos;
    private final long observedTimestampEpochNanos;
    private final SpanContext spanContext;
    private final Severity severity;
    @Nullable
    private final String severityText;
    private final Body body;
    private final Attributes attributes;
    private final int totalAttributeCount;

    AutoValue_SdkLogRecordData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, Body body2, Attributes attributes2, int totalAttributeCount) {
        if (resource == null) {
            throw new NullPointerException("Null resource");
        }
        this.resource = resource;
        if (instrumentationScopeInfo == null) {
            throw new NullPointerException("Null instrumentationScopeInfo");
        }
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        if (spanContext == null) {
            throw new NullPointerException("Null spanContext");
        }
        this.spanContext = spanContext;
        if (severity == null) {
            throw new NullPointerException("Null severity");
        }
        this.severity = severity;
        this.severityText = severityText;
        if (body2 == null) {
            throw new NullPointerException("Null body");
        }
        this.body = body2;
        if (attributes2 == null) {
            throw new NullPointerException("Null attributes");
        }
        this.attributes = attributes2;
        this.totalAttributeCount = totalAttributeCount;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount;
    }

    public String toString() {
        return "SdkLogRecordData{resource=" + this.resource + ", instrumentationScopeInfo=" + this.instrumentationScopeInfo + ", timestampEpochNanos=" + this.timestampEpochNanos + ", observedTimestampEpochNanos=" + this.observedTimestampEpochNanos + ", spanContext=" + this.spanContext + ", severity=" + (Object)((Object)this.severity) + ", severityText=" + this.severityText + ", body=" + this.body + ", attributes=" + this.attributes + ", totalAttributeCount=" + this.totalAttributeCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SdkLogRecordData) {
            SdkLogRecordData that = (SdkLogRecordData)o;
            return this.resource.equals(that.getResource()) && this.instrumentationScopeInfo.equals(that.getInstrumentationScopeInfo()) && this.timestampEpochNanos == that.getTimestampEpochNanos() && this.observedTimestampEpochNanos == that.getObservedTimestampEpochNanos() && this.spanContext.equals(that.getSpanContext()) && this.severity.equals((Object)that.getSeverity()) && (this.severityText == null ? that.getSeverityText() == null : this.severityText.equals(that.getSeverityText())) && this.body.equals(that.getBody()) && this.attributes.equals(that.getAttributes()) && this.totalAttributeCount == that.getTotalAttributeCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.instrumentationScopeInfo.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.timestampEpochNanos >>> 32 ^ this.timestampEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.observedTimestampEpochNanos >>> 32 ^ this.observedTimestampEpochNanos);
        h$ *= 1000003;
        h$ ^= this.spanContext.hashCode();
        h$ *= 1000003;
        h$ ^= this.severity.hashCode();
        h$ *= 1000003;
        h$ ^= this.severityText == null ? 0 : this.severityText.hashCode();
        h$ *= 1000003;
        h$ ^= this.body.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.totalAttributeCount;
    }
}

