/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongGaugeBuilder;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkLongGauge
extends AbstractInstrument
implements LongGauge {
    private final WriteableMetricStorage storage;

    private SdkLongGauge(InstrumentDescriptor descriptor2, WriteableMetricStorage storage2) {
        super(descriptor2);
        this.storage = storage2;
    }

    @Override
    public void set(long value2, Attributes attributes2) {
        this.storage.recordLong(value2, attributes2, Context.current());
    }

    @Override
    public void set(long value2, Attributes attributes2, Context context) {
        this.storage.recordLong(value2, attributes2, context);
    }

    @Override
    public void set(long increment) {
        this.set(increment, Attributes.empty());
    }

    static final class SdkLongGaugeBuilder
    implements ExtendedLongGaugeBuilder {
        private final InstrumentBuilder builder;

        SdkLongGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description2, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.LONG, meterProviderSharedState, sharedState).setDescription(description2).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongGaugeBuilder setDescription(String description2) {
            this.builder.setDescription(description2);
            return this;
        }

        @Override
        public LongGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongGauge build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1) -> new SdkLongGauge((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ExtendedLongGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes2) {
            this.builder.setAdviceAttributes(attributes2);
            return this;
        }

        @Override
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback2) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback2);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

