/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import io.opentelemetry.sdk.metrics.internal.concurrent.DoubleAdder;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previousPoint, DoublePointData currentPoint) {
        return ImmutableDoublePointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(DoublePointData previousReusablePoint, DoublePointData currentPoint) {
        ((MutableDoublePointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor2, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, descriptor2.getName(), descriptor2.getDescription(), descriptor2.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();
        @Nullable
        private final MutableDoublePointData reusablePoint;

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes2, List<DoubleExemplarData> exemplars, boolean reset) {
            double value2;
            double d = value2 = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes2, value2, exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes2, value2, exemplars);
        }

        @Override
        protected void doRecordDouble(double value2) {
            this.current.add(value2);
        }
    }
}

