/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableMetricData;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableMetricData
implements MetricData {
    public static MetricData createDoubleGauge(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, GaugeData<DoublePointData> data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.DOUBLE_GAUGE, data2);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, GaugeData<LongPointData> data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.LONG_GAUGE, data2);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, SumData<DoublePointData> data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.DOUBLE_SUM, data2);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, SumData<LongPointData> data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.LONG_SUM, data2);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, SummaryData data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.SUMMARY, data2);
    }

    public static MetricData createDoubleHistogram(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, HistogramData data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.HISTOGRAM, data2);
    }

    public static MetricData createExponentialHistogram(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, ExponentialHistogramData data2) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description2, unit, MetricDataType.EXPONENTIAL_HISTOGRAM, data2);
    }

    static ImmutableMetricData create(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description2, String unit, MetricDataType type2, Data<?> data2) {
        return new AutoValue_ImmutableMetricData(resource, instrumentationScopeInfo, name, description2, unit, type2, data2);
    }

    ImmutableMetricData() {
    }
}

