/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.EmptyExponentialHistogramBuckets;
import java.util.Collections;
import java.util.List;

public final class MutableExponentialHistogramPointData
implements ExponentialHistogramPointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private int scale;
    private double sum;
    private long count;
    private long zeroCount;
    private boolean hasMin;
    private double min;
    private boolean hasMax;
    private double max;
    private ExponentialHistogramBuckets positiveBuckets = EmptyExponentialHistogramBuckets.get(0);
    private ExponentialHistogramBuckets negativeBuckets = EmptyExponentialHistogramBuckets.get(0);
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getZeroCount() {
        return this.zeroCount;
    }

    @Override
    public boolean hasMin() {
        return this.hasMin;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public boolean hasMax() {
        return this.hasMax;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public ExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    public ExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public ExponentialHistogramPointData set(int scale, double sum, long zeroCount, boolean hasMin, double min2, boolean hasMax, double max, ExponentialHistogramBuckets positiveBuckets, ExponentialHistogramBuckets negativeBuckets, long startEpochNanos, long epochNanos, Attributes attributes2, List<DoubleExemplarData> exemplars) {
        this.count = zeroCount + positiveBuckets.getTotalCount() + negativeBuckets.getTotalCount();
        this.scale = scale;
        this.sum = sum;
        this.zeroCount = zeroCount;
        this.hasMin = hasMin;
        this.min = min2;
        this.hasMax = hasMax;
        this.max = max;
        this.positiveBuckets = positiveBuckets;
        this.negativeBuckets = negativeBuckets;
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes2;
        this.exemplars = exemplars;
        return this;
    }

    public String toString() {
        return "MutableExponentialHistogramPointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", scale=" + this.scale + ", sum=" + this.sum + ", count=" + this.count + ", zeroCount=" + this.zeroCount + ", hasMin=" + this.hasMin + ", min=" + this.min + ", hasMax=" + this.hasMax + ", max=" + this.max + ", positiveBuckets=" + this.positiveBuckets + ", negativeBuckets=" + this.negativeBuckets + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExponentialHistogramPointData) {
            ExponentialHistogramPointData that = (ExponentialHistogramPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && this.scale == that.getScale() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.count == that.getCount() && this.zeroCount == that.getZeroCount() && this.hasMin == that.hasMin() && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(that.getMin()) && this.hasMax == that.hasMax() && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(that.getMax()) && this.positiveBuckets.equals(that.getPositiveBuckets()) && this.negativeBuckets.equals(that.getNegativeBuckets()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        hash ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hash *= 1000003;
        hash ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hash *= 1000003;
        hash ^= this.attributes.hashCode();
        hash *= 1000003;
        hash ^= this.scale;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        hash *= 1000003;
        hash ^= (int)(this.count >>> 32 ^ this.count);
        hash *= 1000003;
        hash ^= (int)(this.zeroCount >>> 32 ^ this.zeroCount);
        hash *= 1000003;
        hash ^= this.hasMin ? 1231 : 1237;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits(this.min) >>> 32 ^ Double.doubleToLongBits(this.min));
        hash *= 1000003;
        hash ^= this.hasMax ? 1231 : 1237;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits(this.max) >>> 32 ^ Double.doubleToLongBits(this.max));
        hash *= 1000003;
        hash ^= this.positiveBuckets.hashCode();
        hash *= 1000003;
        hash ^= this.negativeBuckets.hashCode();
        hash *= 1000003;
        return hash ^= this.exemplars.hashCode();
    }
}

