/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.List;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> boundaries) {
        super(clock, boundaries.size() + 1, new HistogramCellSelector(boundaries), ReservoirCell::getAndResetDouble);
    }

    @Override
    public void offerLongMeasurement(long value2, Attributes attributes2, Context context) {
        super.offerDoubleMeasurement(value2, attributes2, context);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> boundaries) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value2, Attributes attributes2, Context context) {
            return this.reservoirCellIndexFor(cells, (double)value2, attributes2, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value2, Attributes attributes2, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value2);
        }

        @Override
        public void reset() {
        }
    }
}

