/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;

public final class TraceBasedExemplarFilter
implements ExemplarFilter {
    static final ExemplarFilter INSTANCE = new TraceBasedExemplarFilter();

    private TraceBasedExemplarFilter() {
    }

    @Override
    public boolean shouldSampleMeasurement(long value2, Attributes attributes2, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    @Override
    public boolean shouldSampleMeasurement(double value2, Attributes attributes2, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    private static boolean hasSampledTrace(Context context) {
        return Span.fromContext(context).getSpanContext().isSampled();
    }
}

