/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.internal.state.AutoValue_ImmutableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;

@AutoValue
public abstract class ImmutableMeasurement
implements Measurement {
    static ImmutableMeasurement createDouble(long startEpochNanos, long epochNanos, double value2, Attributes attributes2) {
        return new AutoValue_ImmutableMeasurement(startEpochNanos, epochNanos, false, 0L, true, value2, attributes2);
    }

    static ImmutableMeasurement createLong(long startEpochNanos, long epochNanos, long value2, Attributes attributes2) {
        return new AutoValue_ImmutableMeasurement(startEpochNanos, epochNanos, true, value2, false, 0.0, attributes2);
    }

    @Override
    public Measurement withAttributes(Attributes attributes2) {
        if (this.hasDoubleValue()) {
            return ImmutableMeasurement.createDouble(this.startEpochNanos(), this.epochNanos(), this.doubleValue(), attributes2);
        }
        return ImmutableMeasurement.createLong(this.startEpochNanos(), this.epochNanos(), this.longValue(), attributes2);
    }

    @Override
    public Measurement withStartEpochNanos(long startEpochNanos) {
        if (this.hasDoubleValue()) {
            return ImmutableMeasurement.createDouble(startEpochNanos, this.epochNanos(), this.doubleValue(), this.attributes());
        }
        return ImmutableMeasurement.createLong(startEpochNanos, this.epochNanos(), this.longValue(), this.attributes());
    }
}

