/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ResourceBuilder {
    private final AttributesBuilder attributesBuilder = Attributes.builder();
    @Nullable
    private String schemaUrl;

    public ResourceBuilder put(String key2, String value2) {
        if (key2 != null && value2 != null) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, long value2) {
        if (key2 != null) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, double value2) {
        if (key2 != null) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, boolean value2) {
        if (key2 != null) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, String ... values2) {
        if (key2 != null && values2 != null) {
            this.attributesBuilder.put(key2, values2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, long ... values2) {
        if (key2 != null && values2 != null) {
            this.attributesBuilder.put(key2, values2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, double ... values2) {
        if (key2 != null && values2 != null) {
            this.attributesBuilder.put(key2, values2);
        }
        return this;
    }

    public ResourceBuilder put(String key2, boolean ... values2) {
        if (key2 != null && values2 != null) {
            this.attributesBuilder.put(key2, values2);
        }
        return this;
    }

    public <T> ResourceBuilder put(AttributeKey<T> key2, T value2) {
        if (key2 != null && key2.getKey() != null && !key2.getKey().isEmpty() && value2 != null) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder put(AttributeKey<Long> key2, int value2) {
        if (key2 != null && key2.getKey() != null && !key2.getKey().isEmpty()) {
            this.attributesBuilder.put(key2, value2);
        }
        return this;
    }

    public ResourceBuilder putAll(Attributes attributes2) {
        if (attributes2 != null) {
            this.attributesBuilder.putAll(attributes2);
        }
        return this;
    }

    public ResourceBuilder putAll(Resource resource) {
        if (resource != null) {
            this.attributesBuilder.putAll(resource.getAttributes());
        }
        return this;
    }

    public ResourceBuilder removeIf(Predicate<AttributeKey<?>> filter2) {
        this.attributesBuilder.removeIf(filter2);
        return this;
    }

    public ResourceBuilder setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public Resource build() {
        return Resource.create(this.attributesBuilder.build(), this.schemaUrl);
    }
}

