/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNDeserializer;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ATNType;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.LexerAction;
import org.antlr.v4.runtime.atn.LexerChannelAction;
import org.antlr.v4.runtime.atn.LexerCustomAction;
import org.antlr.v4.runtime.atn.LexerModeAction;
import org.antlr.v4.runtime.atn.LexerPushModeAction;
import org.antlr.v4.runtime.atn.LexerTypeAction;
import org.antlr.v4.runtime.atn.LoopEndState;
import org.antlr.v4.runtime.atn.PrecedencePredicateTransition;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;

public class ATNSerializer {
    public ATN atn;
    private final IntegerList data = new IntegerList();
    private final Map<IntervalSet, Boolean> sets = new LinkedHashMap<IntervalSet, Boolean>();
    private final IntegerList nonGreedyStates = new IntegerList();
    private final IntegerList precedenceStates = new IntegerList();

    public ATNSerializer(ATN atn) {
        assert (atn.grammarType != null);
        this.atn = atn;
    }

    public IntegerList serialize() {
        this.addPreamble();
        int nedges = this.addEdges();
        this.addNonGreedyStates();
        this.addPrecedenceStates();
        this.addRuleStatesAndLexerTokenTypes();
        this.addModeStartStates();
        Map<IntervalSet, Integer> setIndices = null;
        setIndices = this.addSets();
        this.addEdges(nedges, setIndices);
        this.addDecisionStartStates();
        this.addLexerActions();
        return this.data;
    }

    private void addPreamble() {
        this.data.add(ATNDeserializer.SERIALIZED_VERSION);
        this.data.add(this.atn.grammarType.ordinal());
        this.data.add(this.atn.maxTokenType);
    }

    private void addLexerActions() {
        if (this.atn.grammarType == ATNType.LEXER) {
            this.data.add(this.atn.lexerActions.length);
            block10: for (LexerAction action : this.atn.lexerActions) {
                this.data.add(action.getActionType().ordinal());
                switch (action.getActionType()) {
                    case CHANNEL: {
                        int channel2 = ((LexerChannelAction)action).getChannel();
                        this.data.add(channel2);
                        this.data.add(0);
                        continue block10;
                    }
                    case CUSTOM: {
                        int ruleIndex = ((LexerCustomAction)action).getRuleIndex();
                        int actionIndex = ((LexerCustomAction)action).getActionIndex();
                        this.data.add(ruleIndex);
                        this.data.add(actionIndex);
                        continue block10;
                    }
                    case MODE: {
                        int mode = ((LexerModeAction)action).getMode();
                        this.data.add(mode);
                        this.data.add(0);
                        continue block10;
                    }
                    case MORE: {
                        this.data.add(0);
                        this.data.add(0);
                        continue block10;
                    }
                    case POP_MODE: {
                        this.data.add(0);
                        this.data.add(0);
                        continue block10;
                    }
                    case PUSH_MODE: {
                        int mode = ((LexerPushModeAction)action).getMode();
                        this.data.add(mode);
                        this.data.add(0);
                        continue block10;
                    }
                    case SKIP: {
                        this.data.add(0);
                        this.data.add(0);
                        continue block10;
                    }
                    case TYPE: {
                        int type2 = ((LexerTypeAction)action).getType();
                        this.data.add(type2);
                        this.data.add(0);
                        continue block10;
                    }
                    default: {
                        String message = String.format(Locale.getDefault(), "The specified lexer action type %s is not valid.", new Object[]{action.getActionType()});
                        throw new IllegalArgumentException(message);
                    }
                }
            }
        }
    }

    private void addDecisionStartStates() {
        int ndecisions = this.atn.decisionToState.size();
        this.data.add(ndecisions);
        for (DecisionState decStartState : this.atn.decisionToState) {
            this.data.add(decStartState.stateNumber);
        }
    }

    private void addEdges(int nedges, Map<IntervalSet, Integer> setIndices) {
        this.data.add(nedges);
        for (ATNState s2 : this.atn.states) {
            if (s2 == null || s2.getStateType() == 7) continue;
            for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
                Transition t2 = s2.transition(i);
                if (this.atn.states.get(t2.target.stateNumber) == null) {
                    throw new IllegalStateException("Cannot serialize a transition to a removed state.");
                }
                int src = s2.stateNumber;
                int trg = t2.target.stateNumber;
                int edgeType = Transition.serializationTypes.get(t2.getClass());
                int arg1 = 0;
                int arg2 = 0;
                int arg3 = 0;
                switch (edgeType) {
                    case 3: {
                        trg = ((RuleTransition)t2).followState.stateNumber;
                        arg1 = ((RuleTransition)t2).target.stateNumber;
                        arg2 = ((RuleTransition)t2).ruleIndex;
                        arg3 = ((RuleTransition)t2).precedence;
                        break;
                    }
                    case 10: {
                        PrecedencePredicateTransition ppt = (PrecedencePredicateTransition)t2;
                        arg1 = ppt.precedence;
                        break;
                    }
                    case 4: {
                        PredicateTransition pt = (PredicateTransition)t2;
                        arg1 = pt.ruleIndex;
                        arg2 = pt.predIndex;
                        arg3 = pt.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 2: {
                        arg1 = ((RangeTransition)t2).from;
                        arg2 = ((RangeTransition)t2).to;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 5: {
                        arg1 = ((AtomTransition)t2).label;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 6: {
                        ActionTransition at = (ActionTransition)t2;
                        arg1 = at.ruleIndex;
                        arg2 = at.actionIndex;
                        arg3 = at.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 7: {
                        arg1 = setIndices.get(((SetTransition)t2).set);
                        break;
                    }
                    case 8: {
                        arg1 = setIndices.get(((SetTransition)t2).set);
                        break;
                    }
                }
                this.data.add(src);
                this.data.add(trg);
                this.data.add(edgeType);
                this.data.add(arg1);
                this.data.add(arg2);
                this.data.add(arg3);
            }
        }
    }

    private Map<IntervalSet, Integer> addSets() {
        ATNSerializer.serializeSets(this.data, this.sets.keySet());
        HashMap<IntervalSet, Integer> setIndices = new HashMap<IntervalSet, Integer>();
        int setIndex = 0;
        for (IntervalSet s2 : this.sets.keySet()) {
            setIndices.put(s2, setIndex++);
        }
        return setIndices;
    }

    private void addModeStartStates() {
        int nmodes = this.atn.modeToStartState.size();
        this.data.add(nmodes);
        if (nmodes > 0) {
            for (ATNState aTNState : this.atn.modeToStartState) {
                this.data.add(aTNState.stateNumber);
            }
        }
    }

    private void addRuleStatesAndLexerTokenTypes() {
        int nrules = this.atn.ruleToStartState.length;
        this.data.add(nrules);
        for (int r = 0; r < nrules; ++r) {
            RuleStartState ruleStartState = this.atn.ruleToStartState[r];
            this.data.add(ruleStartState.stateNumber);
            if (this.atn.grammarType != ATNType.LEXER) continue;
            assert (this.atn.ruleToTokenType[r] >= 0);
            this.data.add(this.atn.ruleToTokenType[r]);
        }
    }

    private void addPrecedenceStates() {
        this.data.add(this.precedenceStates.size());
        for (int i = 0; i < this.precedenceStates.size(); ++i) {
            this.data.add(this.precedenceStates.get(i));
        }
    }

    private void addNonGreedyStates() {
        this.data.add(this.nonGreedyStates.size());
        for (int i = 0; i < this.nonGreedyStates.size(); ++i) {
            this.data.add(this.nonGreedyStates.get(i));
        }
    }

    private int addEdges() {
        int nedges = 0;
        this.data.add(this.atn.states.size());
        for (ATNState s2 : this.atn.states) {
            if (s2 == null) {
                this.data.add(0);
                continue;
            }
            int stateType = s2.getStateType();
            if (s2 instanceof DecisionState && ((DecisionState)s2).nonGreedy) {
                this.nonGreedyStates.add(s2.stateNumber);
            }
            if (s2 instanceof RuleStartState && ((RuleStartState)s2).isLeftRecursiveRule) {
                this.precedenceStates.add(s2.stateNumber);
            }
            this.data.add(stateType);
            this.data.add(s2.ruleIndex);
            if (s2.getStateType() == 12) {
                this.data.add(((LoopEndState)s2).loopBackState.stateNumber);
            } else if (s2 instanceof BlockStartState) {
                this.data.add(((BlockStartState)s2).endState.stateNumber);
            }
            if (s2.getStateType() != 7) {
                nedges += s2.getNumberOfTransitions();
            }
            for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
                Transition t2 = s2.transition(i);
                int edgeType = Transition.serializationTypes.get(t2.getClass());
                if (edgeType != 7 && edgeType != 8) continue;
                SetTransition st = (SetTransition)t2;
                this.sets.put(st.set, true);
            }
        }
        return nedges;
    }

    private static void serializeSets(IntegerList data2, Collection<IntervalSet> sets) {
        int nSets = sets.size();
        data2.add(nSets);
        for (IntervalSet set2 : sets) {
            boolean containsEof = set2.contains(-1);
            if (containsEof && set2.getIntervals().get((int)0).b == -1) {
                data2.add(set2.getIntervals().size() - 1);
            } else {
                data2.add(set2.getIntervals().size());
            }
            data2.add(containsEof ? 1 : 0);
            for (Interval I : set2.getIntervals()) {
                if (I.a == -1) {
                    if (I.b == -1) continue;
                    data2.add(0);
                } else {
                    data2.add(I.a);
                }
                data2.add(I.b);
            }
        }
    }

    public static IntegerList getSerialized(ATN atn) {
        return new ATNSerializer(atn).serialize();
    }
}

