/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.util.Iterator;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.Args;

public final class SimpleHttpResponse
extends BasicHttpResponse {
    private static final long serialVersionUID = 1L;
    private SimpleBody body;

    public SimpleHttpResponse(int code) {
        super(code);
    }

    public SimpleHttpResponse(int code, String reasonPhrase) {
        super(code, reasonPhrase);
    }

    public static SimpleHttpResponse copy(HttpResponse original) {
        Args.notNull(original, "HTTP response");
        SimpleHttpResponse copy2 = new SimpleHttpResponse(original.getCode());
        copy2.setVersion(original.getVersion());
        Iterator<Header> it = original.headerIterator();
        while (it.hasNext()) {
            copy2.addHeader(it.next());
        }
        return copy2;
    }

    public static SimpleHttpResponse create(int code) {
        return new SimpleHttpResponse(code);
    }

    public static SimpleHttpResponse create(int code, String content2, ContentType contentType2) {
        SimpleHttpResponse response2 = new SimpleHttpResponse(code);
        if (content2 != null) {
            response2.setBody(content2, contentType2);
        }
        return response2;
    }

    public static SimpleHttpResponse create(int code, String content2) {
        return SimpleHttpResponse.create(code, content2, ContentType.TEXT_PLAIN);
    }

    public static SimpleHttpResponse create(int code, byte[] content2, ContentType contentType2) {
        SimpleHttpResponse response2 = new SimpleHttpResponse(code);
        if (content2 != null) {
            response2.setBody(content2, contentType2);
        }
        return response2;
    }

    public static SimpleHttpResponse create(int code, byte[] content2) {
        return SimpleHttpResponse.create(code, content2, ContentType.TEXT_PLAIN);
    }

    public void setBody(SimpleBody body2) {
        this.body = body2;
    }

    public void setBody(byte[] bodyBytes, ContentType contentType2) {
        this.body = SimpleBody.create(bodyBytes, contentType2);
    }

    public void setBody(String bodyText, ContentType contentType2) {
        this.body = SimpleBody.create(bodyText, contentType2);
    }

    public SimpleBody getBody() {
        return this.body;
    }

    public ContentType getContentType() {
        return this.body != null ? this.body.getContentType() : null;
    }

    public String getBodyText() {
        return this.body != null ? this.body.getBodyText() : null;
    }

    public byte[] getBodyBytes() {
        return this.body != null ? this.body.getBodyBytes() : null;
    }
}

